// chrome/browser/ui/webui/ash/settings/pages/files/mojom/one_drive_handler.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export class PageHandlerFactoryPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.one_drive.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "ash.settings.one_drive.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.one_drive.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getUserEmailAddress() {
        return this.proxy.sendMessage(0, PageHandler_GetUserEmailAddress_ParamsSpec.$, PageHandler_GetUserEmailAddress_ResponseParamsSpec.$, [], false);
    }
    connectToOneDrive() {
        return this.proxy.sendMessage(1, PageHandler_ConnectToOneDrive_ParamsSpec.$, PageHandler_ConnectToOneDrive_ResponseParamsSpec.$, [], false);
    }
    disconnectFromOneDrive() {
        return this.proxy.sendMessage(2, PageHandler_DisconnectFromOneDrive_ParamsSpec.$, PageHandler_DisconnectFromOneDrive_ResponseParamsSpec.$, [], false);
    }
    openOneDriveFolder() {
        return this.proxy.sendMessage(3, PageHandler_OpenOneDriveFolder_ParamsSpec.$, PageHandler_OpenOneDriveFolder_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetUserEmailAddress_ParamsSpec.$, PageHandler_GetUserEmailAddress_ResponseParamsSpec.$, impl.getUserEmailAddress.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_ConnectToOneDrive_ParamsSpec.$, PageHandler_ConnectToOneDrive_ResponseParamsSpec.$, impl.connectToOneDrive.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_DisconnectFromOneDrive_ParamsSpec.$, PageHandler_DisconnectFromOneDrive_ResponseParamsSpec.$, impl.disconnectFromOneDrive.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_OpenOneDriveFolder_ParamsSpec.$, PageHandler_OpenOneDriveFolder_ResponseParamsSpec.$, impl.openOneDriveFolder.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ash.settings.one_drive.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getUserEmailAddress =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetUserEmailAddress_ParamsSpec.$, PageHandler_GetUserEmailAddress_ResponseParamsSpec.$, this.getUserEmailAddress.createReceiverHandler(true /* expectsResponse */), false);
        this.connectToOneDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_ConnectToOneDrive_ParamsSpec.$, PageHandler_ConnectToOneDrive_ResponseParamsSpec.$, this.connectToOneDrive.createReceiverHandler(true /* expectsResponse */), false);
        this.disconnectFromOneDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_DisconnectFromOneDrive_ParamsSpec.$, PageHandler_DisconnectFromOneDrive_ResponseParamsSpec.$, this.disconnectFromOneDrive.createReceiverHandler(true /* expectsResponse */), false);
        this.openOneDriveFolder =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_OpenOneDriveFolder_ParamsSpec.$, PageHandler_OpenOneDriveFolder_ResponseParamsSpec.$, this.openOneDriveFolder.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.one_drive.mojom.Page', scope);
    }
}
export class PageRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onODFSMountOrUnmount() {
        this.proxy.sendMessage(0, Page_OnODFSMountOrUnmount_ParamsSpec.$, null, [], false);
    }
    onAllowUserToRemoveODFSChanged(isAllowed) {
        this.proxy.sendMessage(1, Page_OnAllowUserToRemoveODFSChanged_ParamsSpec.$, null, [
            isAllowed
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnODFSMountOrUnmount_ParamsSpec.$, null, impl.onODFSMountOrUnmount.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_OnAllowUserToRemoveODFSChanged_ParamsSpec.$, null, impl.onAllowUserToRemoveODFSChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "ash.settings.one_drive.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onODFSMountOrUnmount =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnODFSMountOrUnmount_ParamsSpec.$, null, this.onODFSMountOrUnmount.createReceiverHandler(false /* expectsResponse */), false);
        this.onAllowUserToRemoveODFSChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_OnAllowUserToRemoveODFSChanged_ParamsSpec.$, null, this.onAllowUserToRemoveODFSChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetUserEmailAddress_ParamsSpec = { $: {} };
export const PageHandler_GetUserEmailAddress_ResponseParamsSpec = { $: {} };
export const PageHandler_ConnectToOneDrive_ParamsSpec = { $: {} };
export const PageHandler_ConnectToOneDrive_ResponseParamsSpec = { $: {} };
export const PageHandler_DisconnectFromOneDrive_ParamsSpec = { $: {} };
export const PageHandler_DisconnectFromOneDrive_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenOneDriveFolder_ParamsSpec = { $: {} };
export const PageHandler_OpenOneDriveFolder_ResponseParamsSpec = { $: {} };
export const Page_OnODFSMountOrUnmount_ParamsSpec = { $: {} };
export const Page_OnAllowUserToRemoveODFSChanged_ParamsSpec = { $: {} };
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetUserEmailAddress_ParamsSpec.$, 'PageHandler_GetUserEmailAddress_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetUserEmailAddress_ResponseParamsSpec.$, 'PageHandler_GetUserEmailAddress_ResponseParams', [
    mojo.internal.StructField('email', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ConnectToOneDrive_ParamsSpec.$, 'PageHandler_ConnectToOneDrive_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ConnectToOneDrive_ResponseParamsSpec.$, 'PageHandler_ConnectToOneDrive_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_DisconnectFromOneDrive_ParamsSpec.$, 'PageHandler_DisconnectFromOneDrive_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_DisconnectFromOneDrive_ResponseParamsSpec.$, 'PageHandler_DisconnectFromOneDrive_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenOneDriveFolder_ParamsSpec.$, 'PageHandler_OpenOneDriveFolder_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenOneDriveFolder_ResponseParamsSpec.$, 'PageHandler_OpenOneDriveFolder_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnODFSMountOrUnmount_ParamsSpec.$, 'Page_OnODFSMountOrUnmount_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnAllowUserToRemoveODFSChanged_ParamsSpec.$, 'Page_OnAllowUserToRemoveODFSChanged_Params', [
    mojo.internal.StructField('isAllowed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
