// chrome/browser/ui/webui/ash/settings/search/mojom/search.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { SectionSpec as chromeos_settings_mojom_SectionSpec, SubpageSpec as chromeos_settings_mojom_SubpageSpec } from './routes.mojom-webui.js';
import { SearchResultIconSpec as ash_settings_mojom_SearchResultIconSpec } from './search_result_icon.mojom-webui.js';
import { SettingSpec as chromeos_settings_mojom_SettingSpec } from './setting.mojom-webui.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
export const SearchResultTypeSpec = { $: mojo.internal.Enum() };
export var SearchResultType;
(function (SearchResultType) {
    SearchResultType[SearchResultType["MIN_VALUE"] = 0] = "MIN_VALUE";
    SearchResultType[SearchResultType["MAX_VALUE"] = 2] = "MAX_VALUE";
    SearchResultType[SearchResultType["kSection"] = 0] = "kSection";
    SearchResultType[SearchResultType["kSubpage"] = 1] = "kSubpage";
    SearchResultType[SearchResultType["kSetting"] = 2] = "kSetting";
})(SearchResultType || (SearchResultType = {}));
export const SearchResultDefaultRankSpec = { $: mojo.internal.Enum() };
export var SearchResultDefaultRank;
(function (SearchResultDefaultRank) {
    SearchResultDefaultRank[SearchResultDefaultRank["MIN_VALUE"] = 0] = "MIN_VALUE";
    SearchResultDefaultRank[SearchResultDefaultRank["MAX_VALUE"] = 2] = "MAX_VALUE";
    SearchResultDefaultRank[SearchResultDefaultRank["kHigh"] = 0] = "kHigh";
    SearchResultDefaultRank[SearchResultDefaultRank["kMedium"] = 1] = "kMedium";
    SearchResultDefaultRank[SearchResultDefaultRank["kLow"] = 2] = "kLow";
})(SearchResultDefaultRank || (SearchResultDefaultRank = {}));
export const ParentResultBehaviorSpec = { $: mojo.internal.Enum() };
export var ParentResultBehavior;
(function (ParentResultBehavior) {
    ParentResultBehavior[ParentResultBehavior["MIN_VALUE"] = 0] = "MIN_VALUE";
    ParentResultBehavior[ParentResultBehavior["MAX_VALUE"] = 1] = "MAX_VALUE";
    ParentResultBehavior[ParentResultBehavior["kAllowParentResults"] = 0] = "kAllowParentResults";
    ParentResultBehavior[ParentResultBehavior["kDoNotIncludeParentResults"] = 1] = "kDoNotIncludeParentResults";
})(ParentResultBehavior || (ParentResultBehavior = {}));
export class SearchResultsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.SearchResultsObserver', scope);
    }
}
export class SearchResultsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SearchResultsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onSearchResultsChanged() {
        this.proxy.sendMessage(0, SearchResultsObserver_OnSearchResultsChanged_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the SearchResultsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SearchResultsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SearchResultsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SearchResultsObserver_OnSearchResultsChanged_ParamsSpec.$, null, impl.onSearchResultsChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SearchResultsObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.SearchResultsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SearchResultsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SearchResultsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SearchResultsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SearchResultsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onSearchResultsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SearchResultsObserver_OnSearchResultsChanged_ParamsSpec.$, null, this.onSearchResultsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class SearchHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.SearchHandler', scope);
    }
}
export class SearchHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SearchHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    search(query, maxNumResults, parentResultBehavior) {
        return this.proxy.sendMessage(0, SearchHandler_Search_ParamsSpec.$, SearchHandler_Search_ResponseParamsSpec.$, [
            query,
            maxNumResults,
            parentResultBehavior
        ], false);
    }
    observe(observer) {
        this.proxy.sendMessage(1, SearchHandler_Observe_ParamsSpec.$, null, [
            observer
        ], false);
    }
}
;
/**
 * An object which receives request messages for the SearchHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SearchHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SearchHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SearchHandler_Search_ParamsSpec.$, SearchHandler_Search_ResponseParamsSpec.$, impl.search.bind(impl), false);
        this.helper_internal_.registerHandler(1, SearchHandler_Observe_ParamsSpec.$, null, impl.observe.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SearchHandler {
    static get $interfaceName() {
        return "ash.settings.mojom.SearchHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SearchHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SearchHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SearchHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SearchHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.search =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SearchHandler_Search_ParamsSpec.$, SearchHandler_Search_ResponseParamsSpec.$, this.search.createReceiverHandler(true /* expectsResponse */), false);
        this.observe =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, SearchHandler_Observe_ParamsSpec.$, null, this.observe.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const SearchResultSpec = { $: {} };
export const SearchResultsObserver_OnSearchResultsChanged_ParamsSpec = { $: {} };
export const SearchHandler_Search_ParamsSpec = { $: {} };
export const SearchHandler_Search_ResponseParamsSpec = { $: {} };
export const SearchHandler_Observe_ParamsSpec = { $: {} };
export const SearchResultIdentifierSpec = { $: {} };
mojo.internal.Struct(SearchResultSpec.$, 'SearchResult', [
    mojo.internal.StructField('text', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('canonicalText', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('urlPathWithParameters', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('icon', 24, 0, ash_settings_mojom_SearchResultIconSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('relevanceScore', 32, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settingsPageHierarchy', 40, 0, mojo.internal.Array(mojoBase_mojom_String16Spec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('defaultRank', 28, 0, SearchResultDefaultRankSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('wasGeneratedFromTextMatch', 48, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 52, 0, SearchResultTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 56, 0, SearchResultIdentifierSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 80],]);
mojo.internal.Struct(SearchResultsObserver_OnSearchResultsChanged_ParamsSpec.$, 'SearchResultsObserver_OnSearchResultsChanged_Params', [], [[0, 8],]);
mojo.internal.Struct(SearchHandler_Search_ParamsSpec.$, 'SearchHandler_Search_Params', [
    mojo.internal.StructField('query', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxNumResults', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('parentResultBehavior', 12, 0, ParentResultBehaviorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SearchHandler_Search_ResponseParamsSpec.$, 'SearchHandler_Search_ResponseParams', [
    mojo.internal.StructField('results', 0, 0, mojo.internal.Array(SearchResultSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SearchHandler_Observe_ParamsSpec.$, 'SearchHandler_Observe_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(SearchResultsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(SearchResultIdentifierSpec.$, 'SearchResultIdentifier', {
    'section': {
        'ordinal': 0,
        'type': chromeos_settings_mojom_SectionSpec.$,
    },
    'subpage': {
        'ordinal': 1,
        'type': chromeos_settings_mojom_SubpageSpec.$,
    },
    'setting': {
        'ordinal': 2,
        'type': chromeos_settings_mojom_SettingSpec.$,
    },
});
export var SearchResultIdentifierFieldTags;
(function (SearchResultIdentifierFieldTags) {
    SearchResultIdentifierFieldTags[SearchResultIdentifierFieldTags["SECTION"] = 0] = "SECTION";
    SearchResultIdentifierFieldTags[SearchResultIdentifierFieldTags["SUBPAGE"] = 1] = "SUBPAGE";
    SearchResultIdentifierFieldTags[SearchResultIdentifierFieldTags["SETTING"] = 2] = "SETTING";
})(SearchResultIdentifierFieldTags || (SearchResultIdentifierFieldTags = {}));
export function whichSearchResultIdentifier(u) {
    if (u.section !== null && u.section !== undefined) {
        return SearchResultIdentifierFieldTags.SECTION;
    }
    if (u.subpage !== null && u.subpage !== undefined) {
        return SearchResultIdentifierFieldTags.SUBPAGE;
    }
    if (u.setting !== null && u.setting !== undefined) {
        return SearchResultIdentifierFieldTags.SETTING;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
