// chrome/browser/ui/webui/ash/settings/search/mojom/user_action_recorder.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { SettingSpec as chromeos_settings_mojom_SettingSpec } from './setting.mojom-webui.js';
export class UserActionRecorderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.UserActionRecorder', scope);
    }
}
export class UserActionRecorderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(UserActionRecorderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    recordPageFocus() {
        this.proxy.sendMessage(0, UserActionRecorder_RecordPageFocus_ParamsSpec.$, null, [], false);
    }
    recordPageBlur() {
        this.proxy.sendMessage(1, UserActionRecorder_RecordPageBlur_ParamsSpec.$, null, [], false);
    }
    recordClick() {
        this.proxy.sendMessage(2, UserActionRecorder_RecordClick_ParamsSpec.$, null, [], false);
    }
    recordNavigation() {
        this.proxy.sendMessage(3, UserActionRecorder_RecordNavigation_ParamsSpec.$, null, [], false);
    }
    recordSearch() {
        this.proxy.sendMessage(4, UserActionRecorder_RecordSearch_ParamsSpec.$, null, [], false);
    }
    recordSettingChange() {
        this.proxy.sendMessage(5, UserActionRecorder_RecordSettingChange_ParamsSpec.$, null, [], false);
    }
    recordSettingChangeWithDetails(setting, value) {
        this.proxy.sendMessage(6, UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec.$, null, [
            setting,
            value
        ], false);
    }
}
;
/**
 * An object which receives request messages for the UserActionRecorder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UserActionRecorderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserActionRecorderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, UserActionRecorder_RecordPageFocus_ParamsSpec.$, null, impl.recordPageFocus.bind(impl), false);
        this.helper_internal_.registerHandler(1, UserActionRecorder_RecordPageBlur_ParamsSpec.$, null, impl.recordPageBlur.bind(impl), false);
        this.helper_internal_.registerHandler(2, UserActionRecorder_RecordClick_ParamsSpec.$, null, impl.recordClick.bind(impl), false);
        this.helper_internal_.registerHandler(3, UserActionRecorder_RecordNavigation_ParamsSpec.$, null, impl.recordNavigation.bind(impl), false);
        this.helper_internal_.registerHandler(4, UserActionRecorder_RecordSearch_ParamsSpec.$, null, impl.recordSearch.bind(impl), false);
        this.helper_internal_.registerHandler(5, UserActionRecorder_RecordSettingChange_ParamsSpec.$, null, impl.recordSettingChange.bind(impl), false);
        this.helper_internal_.registerHandler(6, UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec.$, null, impl.recordSettingChangeWithDetails.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class UserActionRecorder {
    static get $interfaceName() {
        return "ash.settings.mojom.UserActionRecorder";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new UserActionRecorderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the UserActionRecorder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UserActionRecorderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserActionRecorderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.recordPageFocus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, UserActionRecorder_RecordPageFocus_ParamsSpec.$, null, this.recordPageFocus.createReceiverHandler(false /* expectsResponse */), false);
        this.recordPageBlur =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, UserActionRecorder_RecordPageBlur_ParamsSpec.$, null, this.recordPageBlur.createReceiverHandler(false /* expectsResponse */), false);
        this.recordClick =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, UserActionRecorder_RecordClick_ParamsSpec.$, null, this.recordClick.createReceiverHandler(false /* expectsResponse */), false);
        this.recordNavigation =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, UserActionRecorder_RecordNavigation_ParamsSpec.$, null, this.recordNavigation.createReceiverHandler(false /* expectsResponse */), false);
        this.recordSearch =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, UserActionRecorder_RecordSearch_ParamsSpec.$, null, this.recordSearch.createReceiverHandler(false /* expectsResponse */), false);
        this.recordSettingChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, UserActionRecorder_RecordSettingChange_ParamsSpec.$, null, this.recordSettingChange.createReceiverHandler(false /* expectsResponse */), false);
        this.recordSettingChangeWithDetails =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec.$, null, this.recordSettingChangeWithDetails.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const UserActionRecorder_RecordPageFocus_ParamsSpec = { $: {} };
export const UserActionRecorder_RecordPageBlur_ParamsSpec = { $: {} };
export const UserActionRecorder_RecordClick_ParamsSpec = { $: {} };
export const UserActionRecorder_RecordNavigation_ParamsSpec = { $: {} };
export const UserActionRecorder_RecordSearch_ParamsSpec = { $: {} };
export const UserActionRecorder_RecordSettingChange_ParamsSpec = { $: {} };
export const UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec = { $: {} };
export const SettingChangeValueSpec = { $: {} };
mojo.internal.Struct(UserActionRecorder_RecordPageFocus_ParamsSpec.$, 'UserActionRecorder_RecordPageFocus_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordPageBlur_ParamsSpec.$, 'UserActionRecorder_RecordPageBlur_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordClick_ParamsSpec.$, 'UserActionRecorder_RecordClick_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordNavigation_ParamsSpec.$, 'UserActionRecorder_RecordNavigation_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordSearch_ParamsSpec.$, 'UserActionRecorder_RecordSearch_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordSettingChange_ParamsSpec.$, 'UserActionRecorder_RecordSettingChange_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec.$, 'UserActionRecorder_RecordSettingChangeWithDetails_Params', [
    mojo.internal.StructField('setting', 0, 0, chromeos_settings_mojom_SettingSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 8, 0, SettingChangeValueSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Union(SettingChangeValueSpec.$, 'SettingChangeValue', {
    'boolValue': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
    },
    'intValue': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
    },
    'stringValue': {
        'ordinal': 2,
        'type': mojo.internal.String,
    },
});
export var SettingChangeValueFieldTags;
(function (SettingChangeValueFieldTags) {
    SettingChangeValueFieldTags[SettingChangeValueFieldTags["BOOL_VALUE"] = 0] = "BOOL_VALUE";
    SettingChangeValueFieldTags[SettingChangeValueFieldTags["INT_VALUE"] = 1] = "INT_VALUE";
    SettingChangeValueFieldTags[SettingChangeValueFieldTags["STRING_VALUE"] = 2] = "STRING_VALUE";
})(SettingChangeValueFieldTags || (SettingChangeValueFieldTags = {}));
export function whichSettingChangeValue(u) {
    if (u.boolValue !== null && u.boolValue !== undefined) {
        return SettingChangeValueFieldTags.BOOL_VALUE;
    }
    if (u.intValue !== null && u.intValue !== undefined) {
        return SettingChangeValueFieldTags.INT_VALUE;
    }
    if (u.stringValue !== null && u.stringValue !== undefined) {
        return SettingChangeValueFieldTags.STRING_VALUE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
