import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">cr-dialog::part(dialog){width:512px}div[slot='title']{flex-direction:column;height:auto}div[slot='body']{align-items:center;display:flex;flex-direction:column;height:auto;justify-content:center;width:464px}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-alert);padding-bottom:13px}#description{display:flex;flex-direction:column;gap:12px}:host(:not([did-setup-attempt-fail_])) #description{height:93px}:host([did-setup-attempt-fail_]) #description{height:60px}#illustration{background-position:center center;background-repeat:no-repeat;background-size:contain;height:200px;margin-bottom:24px;margin-top:24px;width:100%}:host([has-not-started-setup-attempt_]) #illustration{background-image:url(chrome://os-settings/images/notification_access_setup.svg)}:host([is-setup-attempt-in-progress_]) #illustration{background-image:url(chrome://os-settings/images/notification_access_connecting.svg)}:host([did-setup-attempt-fail_]) #illustration{background-image:url(chrome://os-settings/images/notification_access_error.svg)}:host([has-completed-setup-successfully_]) #illustration{background-image:url(chrome://os-settings/images/notification_access_finished.svg)}@media (prefers-color-scheme:dark){:host([has-not-started-setup-attempt_]) #illustration{background-image:url(chrome://os-settings/images/notification_access_setup_dark.svg)}:host([is-setup-attempt-in-progress_]) #illustration{background-image:url(chrome://os-settings/images/notification_access_connecting_dark.svg)}:host([did-setup-attempt-fail_]) #illustration{background-image:url(chrome://os-settings/images/notification_access_error_dark.svg)}:host([has-completed-setup-successfully_]) #illustration{background-image:url(chrome://os-settings/images/notification_access_finished_dark.svg)}}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div id="dialogTitle" slot="title">
    <template is="dom-if" if="[[didSetupAttemptFail_]]" restamp>
      <iron-icon id="failureIcon" icon="os-settings:failure-alert">
      </iron-icon>
    </template>
    <div id="title">[[title_]]</div>
  </div>
  <div id="dialogBody" slot="body">
    <div id="illustration"></div>
    <div id="description">
      <template is="dom-if" if="[[description_]]" restamp>
        <localized-link localized-string="[[description_]]">
        </localized-link>
      </template>
      <div hidden="[[!shouldShowSetupInstructionsSeparately_]]">
        $i18n{multideviceNotificationAccessSetupInstructions}
      </div>
    </div>
  </div>
  <div id="buttonContainer" slot="button-container">
    <template is="dom-if" if="[[shouldShowCancelButton_(setupState_)]]"
        restamp>
      <cr-button id="cancelButton" class="cancel-button"
          on-click="onCancelClicked_">
        $i18n{cancel}
      </cr-button>
    </template>
    <template is="dom-if" if="[[hasCompletedSetupSuccessfully_]]" restamp>
      <cr-button id="doneButton" class="action-button"
          on-click="onDoneOrCloseButtonClicked_">
        $i18n{done}
      </cr-button>
    </template>
    <template is="dom-if" if="[[isNotificationAccessProhibited_]]" restamp>
      <cr-button id="closeButton" class="action-button"
          on-click="onDoneOrCloseButtonClicked_">
        $i18n{close}
      </cr-button>
    </template>
    <template is="dom-if" if="[[hasNotStartedSetupAttempt_]]" restamp>
      <cr-button id="getStartedButton" class="action-button"
          on-click="attemptNotificationSetup_">
        $i18n{multideviceNotificationAccessSetupGetStarted}
      </cr-button>
    </template>
    <template is="dom-if" if="[[shouldShowTryAgainButton_(setupState_)]]"
        restamp>
      <cr-button id="tryAgainButton" class="action-button"
          on-click="attemptNotificationSetup_">
        $i18n{multideviceNotificationAccessSetupTryAgain}
      </cr-button>
    </template>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
