import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">cr-policy-indicator{padding:0 var(--cr-controlled-by-spacing)}#betterTogetherSuiteIcon,#nearbyShareIcon{--iron-icon-fill-color:var(--cros-sys-primary)}</style>

<os-settings-animated-pages id="pages" section="[[section_]]">
  <div route-path="default">
    <settings-card header-text="$i18n{multidevicePageTitle}">
      <div id="multideviceItem"
          class="settings-box first two-line no-padding">
        <div class="link-wrapper" id="suiteLinkWrapper"
            actionable$="[[doesClickOpenSubpage_(pageContentData)]]"
            on-click="handleItemClick_">
          <iron-icon
              id="betterTogetherSuiteIcon"
              icon="[[getIconName(MultiDeviceFeature.BETTER_TOGETHER_SUITE)]]">
          </iron-icon>
          <div class="middle settings-box-text"
              aria-hidden$="[[getTextAriaHidden_(pageContentData)]]">
            <div id="multideviceLabel">
              $i18n{multideviceSetupItemHeading}
            </div>
            <localized-link id="multideviceSubLabel"
                class="secondary"
                localized-string="[[getSubLabelInnerHtml_(pageContentData)]]">
            </localized-link>
          </div>
          <template is="dom-if"
                    if="[[doesClickOpenSubpage_(pageContentData)]]"
                    restamp>
            <cr-icon-button class="subpage-arrow"
                aria-labelledby="multideviceLabel"
                aria-describedby="multideviceSubLabel"
                aria-roledescription="$i18n{subpageArrowRoleDescription}">
            </cr-icon-button>
          </template>
        </div>
        <template is="dom-if"
                  if="[[!isSuiteAllowedByPolicy(pageContentData)]]"
                  restamp>
          <cr-policy-indicator id="suitePolicyIndicator"
              indicator-type="userPolicy">
          </cr-policy-indicator>
          <settings-multidevice-feature-toggle
              class="margin-matches-padding"
              toggle-aria-label="$i18n{multideviceSuiteToggleA11yLabel}"
              feature="[[MultiDeviceFeature.BETTER_TOGETHER_SUITE]]"
              page-content-data="[[pageContentData]]"
              deep-link-focus-id$="[[Setting.kMultiDeviceOnOff]]">
          </settings-multidevice-feature-toggle>
        </template>
        <template is="dom-if"
            if="[[shouldShowSeparatorAndSubpageArrow_(pageContentData)]]"
            restamp>
          <div class="separator"></div>
        </template>
        <template is="dom-if"
            if="[[shouldShowButton_(pageContentData)]]"
            restamp>
          <cr-button class="margin-matches-padding"
              on-click="handleButtonClick_"
              aria-label="[[getButtonA11yLabel_(pageContentData)]]"
              deep-link-focus-id$="[[Setting.kSetUpMultiDevice]]
                  [[Setting.kVerifyMultiDeviceSetup]]">
            [[getButtonText_(pageContentData)]]
          </cr-button>
        </template>
        <template is="dom-if"
            if="[[shouldShowToggle_(pageContentData)]]"
            restamp>
          <settings-multidevice-feature-toggle
              class="margin-matches-padding"
              toggle-aria-label="$i18n{multideviceSuiteToggleA11yLabel}"
              feature="[[MultiDeviceFeature.BETTER_TOGETHER_SUITE]]"
              page-content-data="[[pageContentData]]"
              deep-link-focus-id$="[[Setting.kMultiDeviceOnOff]]">
          </settings-multidevice-feature-toggle>
        </template>
      </div>
      <template is="dom-if" if="[[isNearbyShareSupported_]]" restamp>
        <div id="nearbyshare-item" class="settings-box two-line no-padding">
          <div class="link-wrapper" id="nearbyLinkWrapper"
              actionable$=
                  "[[!isNearbyShareDisallowedByPolicy_(pageContentData)]]"
              on-click="nearbyShareClick_">
            
            
              <iron-icon id="nearbyShareIcon"
                  icon="os-settings:nearby-share">
              </iron-icon>
            
            <div class="middle settings-box-text">
              <div id="nearbyShareLabel" aria-hidden="true">
                $i18n{nearbyShareTitle}
              </div>
              <template is="dom-if" if="[[showNearbyShareOnOffString_(
                        prefs.nearby_sharing.onboarding_complete.value,
                        pageContentData)]]" restamp>
                  <template is="dom-if" if="[[prefs.nearby_sharing.enabled.value]]">
                    <div class="secondary" id="nearbyShareSecondary">
                    [[getNearbyShareDescription_(settings.visibility)]]
                  </div>
                  </template>
                  <template is="dom-if" if="[[!prefs.nearby_sharing.enabled.value]]">
                    <div class="secondary" id="nearbyShareSecondary">
                      <localized-link
                        localized-string="$i18n{nearbyShareDescriptionOff}"
                        link-url="$i18n{nearbyShareLearnMoreLink}">
                      </localized-link>
                    </div>
                  </template>
              </template>
              <template is="dom-if" if="[[showNearbyShareSetUpDescription_(
                        prefs.nearby_sharing.onboarding_complete.value,
                        pageContentData)]]" restamp>
                <div class="secondary" id="nearbyShareSecondary">
                  <localized-link
                      id="setupDescription"
                      localized-string="$i18n{nearbyShareDescription}"
                      link-url="$i18n{nearbyShareLearnMoreLink}">
                  </localized-link>
                </div>
              </template>
            </div>
            <template is="dom-if" if="[[shouldShowNearbyShareSubpageArrow_(
                prefs.nearby_sharing.enabled.value,
                shouldEnableNearbyShareBackgroundScanningRevamp_,
                pageContentData)]]" restamp>
              <cr-icon-button id="nearbyShareSubpageArrow"
                  class="subpage-arrow"
                  aria-labelledby="nearbyShareLabel"
                  aria-describedby="nearbyShareSecondary"
                  aria-roledescription="$i18n{subpageArrowRoleDescription}">
              </cr-icon-button>
            </template>
          </div>
          <template is="dom-if"
              if="[[isNearbyShareDisallowedByPolicy_(pageContentData)]]"
              restamp>
            <cr-policy-indicator id="nearbyPolicyIndicator"
                                  indicator-type="userPolicy">
            </cr-policy-indicator>
          </template>
          <template is="dom-if"
              if="[[!isNearbyShareDisallowedByPolicy_(pageContentData)]]"
              restamp>
            <div class="separator"></div>
          </template>
          <template is="dom-if" if="[[showNearbyShareToggle_(
                    prefs.nearby_sharing.onboarding_complete.value,
                    pageContentData)]]" restamp>
            <cr-toggle id="nearbySharingToggleButton"
                class="margin-matches-padding"
                aria-label="$i18n{nearbyShareTitle}"
                checked="{{prefs.nearby_sharing.enabled.value}}"
                disabled=
                    "[[isNearbyShareDisallowedByPolicy_(pageContentData)]]"
                deep-link-focus-id$="[[Setting.kNearbyShareOnOff]]">
            </cr-toggle>
          </template>
          <template is="dom-if" if="[[showNearbyShareSetupButton_(
                    prefs.nearby_sharing.onboarding_complete.value,
                    pageContentData)]]" restamp>
            <cr-button class="margin-matches-padding"
                id="nearbySetUp"
                on-click="handleNearbySetUpClick_"
                disabled=
                    "[[isNearbyShareDisallowedByPolicy_(pageContentData)]]">
              $i18n{nearbyShareSetUpButtonTitle}
            </cr-button>
          </template>
        </div>
      </template>
    </div>
  </div>

  <template is="dom-if" route-path="/multidevice/features" restamp>
    <os-settings-subpage
        page-title="[[getMultideviceSubpageTitle_(pageContentData)]]">
      <div slot="subpage-title-extra">
        <cr-button id="forgetDeviceButton" on-click="showForgetDeviceDialog_"
            deep-link-focus-id$="[[Setting.kForgetPhone]]">
          $i18n{multideviceForgetDeviceDisconnect}
        </cr-button>
      </div>
      <div id="settingsMultideviceSubpageWrapper" tabindex="-1">
        <settings-multidevice-subpage
            page-content-data="[[pageContentData]]">
        </settings-multidevice-subpage>
      </div>
    </os-settings-subpage>
  </template>
  <template is="dom-if" if="[[isNearbyShareSupported_]]" restamp>
    <template is="dom-if" route-path="/multidevice/nearbyshare" restamp>
      <os-settings-subpage page-title="$i18n{nearbyShareTitle}">
        <settings-nearby-share-subpage settings="{{settings}}"
            prefs="{{prefs}}"
            is-settings-retreived="[[isSettingsRetreived]]">
        </settings-nearby-share-subpage>
      </os-settings-subpage>
    </template>
  </template>
</os-settings-animated-pages>
<template is="dom-if" if="[[showPasswordPromptDialog_]]" restamp>
  <settings-password-prompt-dialog id="multidevicePasswordPrompt"
      on-token-obtained="onTokenObtained_">
  </settings-password-prompt-dialog>
</template>
<template is="dom-if" if="[[showPermissionsSetupDialog_(
    showPhonePermissionSetupDialog_)]]"
    restamp>
  <settings-multidevice-notification-access-setup-dialog
      is-password-dialog-showing="{{isPasswordDialogShowing_}}"
      on-close="onHidePhonePermissionsSetupDialog_">
  </settings-multidevice-notification-access-setup-dialog>
</template>
<template is="dom-if"
    if="[[showNewPermissionsSetupDialog_(
    showPhonePermissionSetupDialog_)]]"
    restamp>
  <settings-multidevice-permissions-setup-dialog
      is-password-dialog-showing="{{isPasswordDialogShowing_}}"
      on-pin-number-selected="onPinNumberSelected_"
      is-chromeos-screen-lock-enabled="[[isChromeosScreenLockEnabled_]]"
      is-phone-screen-lock-enabled="[[isPhoneScreenLockEnabled_]]"
      show-camera-roll="[[isPhoneHubCameraRollSetupRequired(
                                        pageContentData)]]"
      show-notifications="[[isPhoneHubNotificationsSetupRequired(
                                          pageContentData)]]"
      show-app-streaming="[[isPhoneHubAppsSetupRequired(
                                          pageContentData)]]"
      combined-setup-supported="[[isCombinedSetupSupported_(
                                          pageContentData)]]"
      on-close="onHidePhonePermissionsSetupDialog_">
  </settings-multidevice-permissions-setup-dialog>
</template>

<template is="dom-if" if="[[shouldShowForgetDeviceDialog_]]" restamp>
  <settings-multidevice-forget-device-dialog
      on-close="closeForgetDeviceDialog_">
  </settings-multidevice-forget-device-dialog>
</template>
<!--_html_template_end_-->`;
}
