import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">#screen-lock-description{align-items:center;display:flex;flex-direction:row;height:auto;justify-content:center}#half-container{flex:1;height:216px}#illustration{background-image:url(chrome://os-settings/images/multidevice_permission_setup_connecting.svg);background-position:center center;background-repeat:no-repeat;background-size:contain;height:200px;margin-bottom:8px;margin-top:8px;width:100%}@media (prefers-color-scheme:dark){#illustration{background-image:url(chrome://os-settings/images/multidevice_permission_setup_connecting_dark.svg)}}#radio-button-container{padding-top:20px}#passwordRadioButton{--cr-radio-button-label-spacing:20px;--cr-radio-button-size:20px;color:var(--cr-primary-text-color);min-height:20px;padding-inline-start:8px;padding-top:24px}#pinRadioButton{--cr-radio-button-label-spacing:20px;--cr-radio-button-size:20px;color:var(--cr-primary-text-color);min-height:20px;padding-inline-start:8px;padding-top:44px}#subtext{color:var(--cr-secondary-text-color);padding-inline-start:48px}</style>
<div id="screen-lock-description">
  <div id="half-container">
    <div id="illustration"></div>
  </div>
  <div id="half-container">
    <template is="dom-if" if="[[authTokenInfo_]]">
      <cr-radio-group id=radio-button-container
          disabled$="[[quickUnlockDisabledByPolicy_]]"
          selected="{{selectedUnlockType}}"
          deep-link-focus-id$="[[Setting.kChangeAuthPinV2]]">
        <cr-radio-button id="passwordRadioButton" name="password"
            label="$i18n{lockScreenPasswordOnly}">
        </cr-radio-button>
        <cr-radio-button id="pinRadioButton" name="pin+password"
            label="$i18n{lockScreenPinOrPassword}">
        </cr-radio-button>
      </cr-radio-group>
    </template>
  </div>
</div>
<template is="dom-if" if="[[shouldPromptPasswordDialog_]]" restamp>
  <settings-lock-screen-password-prompt-dialog id="passwordDialog"
      on-close="onPasswordPromptDialogClose_"
      on-auth-token-obtained="onAuthTokenObtained_">
  </settings-lock-screen-password-prompt-dialog>
</template>
<template is="dom-if" if="[[showSetupPinDialog]]" restamp>
  <settings-setup-pin-dialog id="setupPin"
      auth-token="[[authTokenInfo_.token]]"
      on-close="onSetupPinDialogClose_">
  </settings-setup-pin-dialog>
</template>
<!--_html_template_end_-->`;
}
