import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex">settings-multidevice-feature-item,settings-multidevice-tether-item{--feature-item-row-padding:0}settings-multidevice-feature-item:first-of-type{--feature-item-border-top-style:none}cr-button{white-space:nowrap}#feature-items-container{padding-inline-start:var(--cr-section-indent-padding)}</style>
<div class="settings-box first">
  <div id="status-text-container"
      class="start"
      enabled$="[[isSuiteOn(pageContentData)]]"
      inner-h-t-m-l="[[getStatusInnerHtml_(pageContentData)]]">
  </div>
    <template is="dom-if" if="[[shouldShowVerifyButton_(pageContentData)]]"
        restamp>
      <cr-button
        aria-label="$i18n{multideviceVerifyButtonA11yLabel}"
        on-click="handleVerifyButtonClick_">
        $i18n{multideviceVerifyButton}
      </cr-button>
    </template>
    <template is="dom-if" if="[[shouldShowSuiteToggle_(pageContentData)]]"
        restamp>
      <settings-multidevice-feature-toggle
          toggle-aria-label="$i18n{multideviceSuiteToggleA11yLabel}"
          feature="[[MultiDeviceFeature.BETTER_TOGETHER_SUITE]]"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kMultiDeviceOnOff]]">
      </settings-multidevice-feature-toggle>
    </template>
</div>
<template is="dom-if"
    if="[[shouldShowIndividualFeatures_(pageContentData)]]"
    restamp>
  <div id="feature-items-container">
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.SMART_LOCK, pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="smartLockItem"
          feature="[[MultiDeviceFeature.SMART_LOCK]]"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kSmartLockOnOff]]">
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.INSTANT_TETHERING, pageContentData)]]"
        restamp>
      <settings-multidevice-tether-item id="instantTetheringItem"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kInstantTetheringOnOff]]">
      </settings-multidevice-tether-item>
    </template>
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.PHONE_HUB, pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="phoneHubItem"
          feature="[[MultiDeviceFeature.PHONE_HUB]]"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kPhoneHubOnOff]]">
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.PHONE_HUB_TASK_CONTINUATION,
            pageContentData)]]"
        restamp>
      <settings-multidevice-task-continuation-item
          id="phoneHubTaskContinuationItem"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kPhoneHubTaskContinuationOnOff]]">
      </settings-multidevice-task-continuation-item>
    </template>
    <template is="dom-if"
        if="[[shouldShowPhoneHubCameraRollItem_(pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="phoneHubCameraRollItem"
          feature="[[MultiDeviceFeature.PHONE_HUB_CAMERA_ROLL]]"
          page-content-data="[[pageContentData]]" is-sub-feature
          deep-link-focus-id$="[[Setting.kPhoneHubCameraRollOnOff]]">
        <template is="dom-if"
            if="[[isPhoneHubCameraRollSetupRequired(pageContentData)]]"
            restamp>
          <cr-button on-click="handleCameraRollSetupClicked_"
              slot="feature-controller"
              disabled="[[isPhoneHubDisabled_(pageContentData)]]">
            $i18n{multideviceSetupButton}
          </cr-button>
        </template>
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[shouldShowPhoneHubNotificationsItem_(pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="phoneHubNotificationsItem"
          feature="[[MultiDeviceFeature.PHONE_HUB_NOTIFICATIONS]]"
          icon-tooltip="[[getPhoneHubNotificationsTooltip_(
                              pageContentData)]]"
          icon="cr:domain"
          page-content-data="[[pageContentData]]" is-sub-feature
          deep-link-focus-id$="[[Setting.kPhoneHubNotificationsOnOff]]">
        <template is="dom-if"
            if="[[isPhoneHubNotificationsSetupRequired(pageContentData)]]"
            restamp>
          <cr-button on-click="handleNotificationSetupClicked_"
              slot="feature-controller"
              disabled="[[isPhoneHubDisabled_(pageContentData)]]">
            $i18n{multideviceSetupButton}
          </cr-button>
        </template>
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[shouldShowPhoneHubAppsItem_(pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="phoneHubAppsItem"
          feature="[[MultiDeviceFeature.ECHE]]"
          icon-tooltip="[[getPhoneHubAppsTooltip_(
                              pageContentData)]]"
          icon="cr:domain"
          page-content-data="[[pageContentData]]" is-sub-feature
          deep-link-focus-id$="[[Setting.kPhoneHubAppsOnOff]]">
        <template is="dom-if"
            if="[[isPhoneHubAppsSetupRequired(pageContentData)]]"
            restamp>
          <cr-button on-click="handleMessagingAppSetupClicked_"
              slot="feature-controller"
              disabled="[[isPhoneHubDisabled_(pageContentData)]]">
            $i18n{multideviceSetupButton}
          </cr-button>
        </template>
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[shouldShowPhoneHubCombinedSetupItem_(pageContentData)]]"
        restamp>
      <settings-multidevice-combined-setup-item
          id="phoneHubCombinedSetupItem"
          camera-roll="[[isPhoneHubCameraRollSetupRequired(
                            pageContentData)]]"
          notifications="[[isPhoneHubNotificationsSetupRequired(
                            pageContentData)]]"
          app-streaming="[[isPhoneHubAppsSetupRequired(pageContentData)]]"
          page-content-data="[[pageContentData]]">
      </settings-multidevice-combined-setup-item>
    </template>
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.WIFI_SYNC, pageContentData)]]"
        restamp>
      <settings-multidevice-wifi-sync-item id="wifiSyncItem"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kWifiSyncOnOff]]">
      </settings-multidevice-wifi-sync-item>
    </template>
  </div>
</template>
<!--_html_template_end_-->`;
}
