import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-dialog-width:340px}.title{color:var(--cros-primary-text-color);margin:0;padding-block-end:0;padding-block-start:24px}cr-radio-group{margin-block-end:12px;margin-inline-start:2px}.data-usage-name{font-weight:600;padding-block-start:20px}#dataUsageDataIcon{--iron-icon-fill-color:var(--cros-icon-color-secondary);height:16px;padding-bottom:2px;width:16px}</style>
<cr-dialog id="dialog">
  <div slot="title" class="title">$i18n{nearbyShareDataUsageDialogTitle}</div>
  <div slot="body">
    <cr-radio-group selected="[[selectedDataUsage_(
        settings.dataUsage)]]">
      <cr-radio-button id="dataUsageDataButton"
          name="[[NearbyShareDataUsageEnum_.ONLINE]]"
          aria-labelledby="dataUsageDataLabel"
          aria-describedby="dataUsageDataDescription
              dataUsageDataTooltipText">
        <div id="dataUsageDataLabel" class="data-usage-name"
            aria-hidden="true">
          $i18n{nearbyShareDataUsageDataLabel}
          <iron-icon id="dataUsageDataIcon"
              icon="cr:info-outline"
              aria-hidden="true"
              tabIndex="0">
          </iron-icon>
          <paper-tooltip id="dataUsageDataTooltip"
              for="dataUsageDataIcon"
              offset="8"
              position="bottom"
              fit-to-visible-bounds>
            <span id="dataUsageDataTooltipText">
              $i18n{nearbyShareDataUsageDataTooltip}
            </span>
          </paper-tooltip>
        </div>
        <div id="dataUsageDataDescription" aria-hidden="true">
          $i18n{nearbyShareDataUsageDataDescription}
        </div>
      </cr-radio-button>
      <cr-radio-button id="dataUsageWifiOnlyButton"
          name="[[NearbyShareDataUsageEnum_.WIFI_ONLY]]"
          aria-labelledby="dataUsageWifiOnlyLabel"
          aria-describedby="dataUsageWifiOnlyDescription">
        <div id="dataUsageWifiOnlyLabel" class="data-usage-name"
            aria-hidden="true">
          $i18n{nearbyShareDataUsageWifiOnlyLabel}
        </div>
        <div id="dataUsageWifiOnlyDescription" aria-hidden="true">
          $i18n{nearbyShareDataUsageWifiOnlyDescription}
        </div>
      </cr-radio-button>
      <cr-radio-button id="dataUsageOfflineButton"
          name="[[NearbyShareDataUsageEnum_.OFFLINE]]"
          aria-labelledby="dataUsageOfflineLabel"
          aria-describedby="dataUsageOfflineDescription">
        <div id="dataUsageOfflineLabel" class="data-usage-name"
            aria-hidden="true">
          $i18n{nearbyShareDataUsageOfflineLabel}
        </div>
        <div id="dataUsageOfflineDescription" aria-hidden="true">
          $i18n{nearbyShareDataUsageOfflineDescription}
        </div>
      </cr-radio-button>
    </cr-radio-group>
  </div>
  <div class="layout horizontal center" slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onSaveClick_">
      $i18n{nearbyShareUpdateDataUsage}
    </cr-button>
</cr-dialog>
<!--_html_template_end_-->`;
}
