import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-dialog-width:340px}[slot="body"]{padding-top:5px}.title{color:var(--cros-primary-text-color);margin:0;padding-block-end:24px;padding-block-start:24px}</style>
<cr-dialog id="dialog">
  <div slot="title" class="title">$i18n{nearbyShareDeviceNameDialogTitle}</div>
  <div slot="body">
    <cr-input value="[[settings.deviceName]]"
        on-input="onDeviceNameInput_"
        error-message="[[errorMessage]]"
        invalid="[[hasErrorMessage_(errorMessage)]]" autofocus>
    </cr-input>
  </div>
  <div class="layout horizontal center" slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="doneButton"
        class="action-button"
        on-click="onSaveClick_"
        disabled="[[hasErrorMessage_(errorMessage)]]">
      $i18n{nearbyShareConfirmDeviceName}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
