import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>#content{background:linear-gradient(to top,var(--nearby-page-linear-gradient-color-start) 5%,transparent 50%);display:flex;flex-direction:column-reverse;height:100%;position:relative;width:100%}#help{align-items:flex-start;color:var(--cros-sys-secondary);display:flex;flex-direction:row;font:var(--cros-annotation-2-font);margin-inline-end:24px;margin-inline-start:24px;padding:8px}#helpText{margin:auto 0}#infoIcon{flex-shrink:0;height:16px;margin-inline-end:8px;width:16px}.icon-help-state{fill:var(--cros-sys-secondary)}.icon-error-state{fill:var(--cros-sys-error)}#error{align-items:flex-start;display:flex;flex-direction:column}#errorTitle{color:var(--cros-sys-error);font:var(--cros-button-2-font);margin-bottom:3px}#errorDescription{color:var(--cros-sys-secondary);font:var(--cros-annotation-2-font)}#animation{bottom:0;height:100px;left:0;pointer-events:none;position:absolute;right:0}</style>
<nearby-page-template title="$i18n{nearbyShareFeatureName}"
    sub-title="[[getSubTitle_(deviceName, remainingTimeInSeconds_)]]"
    a11y-announced-sub-title="[[getA11yAnnouncedSubTitle_(deviceName,
                              remainingTimeInSeconds_)]]"
    cancel-button-label="$i18n{cancel}"
    close-only="[[getErrorTitle_(errorState_)]]">
  <div id="content" slot="content">
      <cros-lottie-renderer id="animation" asset-url="[[getAnimationUrl_()]]"
          autoplay dynamic aria-hidden>
      </cros-lottie-renderer>
    <div id="help">
      <template is="dom-if" if="[[!getErrorTitle_(errorState_)]]" restamp>
        <iron-icon id="infoIcon" icon="nearby20:info"
            class="icon-help-state">
        </iron-icon>
        <div id="helpText">
          <localized-link
              localized-string="$i18n{nearbyShareHighVisibilityHelpText}"
              link-url="$i18n{nearbyShareLearnMoreLink}">
          </localized-link>
        </div>
      </template>
      <template is="dom-if" if="[[getErrorTitle_(errorState_)]]">
        <iron-icon id="infoIcon" icon="nearby20:info"
            class="icon-error-state">
        </iron-icon>
        <div id="error" role="alert" aria-labelledby="errorTitle"
            aria-describedby="errorDescription">
          <div id="errorTitle" aria-hidden="true">
            [[getErrorTitle_(errorState_)]]
          </div>
          <div id="errorDescription" aria-hidden="true">
            <localized-link
                localized-string="[[getErrorDescription_(errorState_)]]"
                link-url="$i18n{nearbyShareLearnMoreLink}">
            </localized-link>
          </div>
        </div>
      </template>
    </div>
  </div>
</nearby-page-template>
<!--_html_template_end_-->`;
}
