import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.settings-box{padding-inline-start:0}.start-padding{padding-inline-start:var(--cr-section-padding)}.button-container{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}settings-toggle-button,cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}.settings-box.indented{margin-inline-start:var(--cr-section-indent-width)}</style>

<settings-toggle-button id="monoAudioEnabled"
    pref="{{prefs.settings.a11y.mono_audio}}"
    label="$i18n{monoAudioLabel}"
    sub-label="$i18n{monoAudioDescription}"
    deep-link-focus-id$="[[Setting.kMonoAudio]]">
</settings-toggle-button>
<div class="settings-box start-padding">
  <div class="start settings-box-text" id="startupSoundEnabledLabel">
    $i18n{startupSoundLabel}
  </div>
  <cr-toggle id="startupSoundEnabled"
      aria-labelledby="startupSoundEnabledLabel"
      deep-link-focus-id$="[[Setting.kStartupSound]]"
      on-change="toggleStartupSoundEnabled_">
  </cr-toggle>
</div>
<template is="dom-if"
    if="[[isAccessibilityFlashNotificationFeatureEnabled_]]">
  <settings-toggle-button id="flashNotificationsToggle"
    class="hr"
    pref="{{prefs.settings.a11y.flash_notifications_enabled}}"
    label="$i18n{flashNotificationsLabel}"
    sub-label="$i18n{flashNotificationsDescription}"
    deep-link-focus-id$="[[Setting.kFlashNotifications]]">
  </settings-toggle-button>
  <template is="dom-if"
      if="[[prefs.settings.a11y.flash_notifications_enabled.value]]">
    <div class="settings-box indented"
        id="flashNotificationsColorOptionsRow">
      <div class="start settings-box-text"
          id="flashNotificationsColorOptionsLabel">
        $i18n{flashNotificationsColorOptionsLabel}
      </div>
      <div class="button-container">
        <cr-button id="notificationPreviewBtn"
            on-click="previewFlashNotification_"
            aria-label="$i18n{flashNotificationsPreviewButtonLabel}">
          $i18n{flashNotificationsPreviewButton}
        </cr-button>
      </div>
      <settings-dropdown-menu id="notificationColorDropdown"
          pref="{{prefs.settings.a11y.flash_notifications_color}}"
          label="$i18n{flashNotificationsColorOptionsLabel}"
          menu-options="[[notificationColorOptions_]]">
      </settings-dropdown-menu>
    </div>
  </template>
</template>
<template is="dom-if" if="[[!isKioskModeActive_]]">
  <settings-captions prefs="{{prefs}}"
      languages="[[languages]]"
      language-helper="[[languageHelper]]">
  </settings-captions>
</template>
<!--_html_template_end_-->`;
}
