import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">settings-dropdown-menu{--md-select-width:100%}.container{align-items:center;display:flex;flex:1;justify-content:space-between;margin-inline-end:var(--cr-section-padding);min-height:var(--cr-section-min-height)}#pinContainer{align-items:baseline;display:flex;height:32px}#pinLabel{margin-inline-end:var(--cr-section-padding)}.controls{align-items:center;display:flex;flex:1}.menu{flex:1}.menu,.button{margin-inline-start:16px}
</style>

<div class="container">
  <span class="label">$i18n{chromeVoxBluetoothBrailleDisplaySelectLabel}</span>
  <template is="dom-if" if="[[inPinMode_]]">
    <div id="pinContainer">
      <div id="pinLabel" class="controls">
        $i18n{chromeVoxBluetoothBrailleDisplayPincodeLabel}
      </div>
      <cr-input
          id="pinCode"
          aria-label="$i18n{chromeVoxBluetoothBrailleDisplayPincodeLabel}"
          type="text"
          on-change="onPincodeChanged_">
      </cr-input>
    </div>
  </template>
  <template is="dom-if" if="[[!inPinMode_]]">
    <div id="controls" class="controls">
      <settings-dropdown-menu
          id="displaySelect"
          class="menu"
          label="$i18n{chromeVoxBluetoothBrailleDisplaySelectLabel}"
          pref="{{brailleDisplayAddressPref_}}"
          menu-options="[[brailleDisplayMenuOptions_]]">
      </settings-dropdown-menu>
      <cr-button id="connectOrDisconnect" class="button">
        $i18n{chromeVoxBluetoothBrailleDisplayConnect}
      </cr-button>
      <cr-button id="forget" class="button">
        $i18n{chromeVoxBluetoothBrailleDisplayForget}
      </cr-button>
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}
