import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex shared-style">#dialogBody{display:flex;flex-direction:column;height:420px;overflow:auto;padding-inline-end:0;padding-inline-start:0}h3{color:var(--cros-text-color-secondary);font-size:inherit;margin:0;min-height:36px;padding-bottom:0;padding-top:0}cr-search-field{margin-bottom:16px;margin-inline-end:var(--dialog-horizontal-padding);margin-inline-start:var(--dialog-horizontal-padding);margin-top:16px}iron-icon[icon='cr:check-circle']{margin-inline-end:26px}.previous{fill:var(--cros-text-color-secondary)}.active{fill:var(--cr-link-color)}.hidden{visibility:hidden}.subtitle{color:var(--cros-text-color-secondary)}iron-list>div:not(.selected):hover{background-color:var(--cros-menu-item-bg-color-focus)}[scrollable] iron-list>:not(.no-outline):focus{background-color:var(--cros-menu-item-bg-color-focus)}[scrollable] iron-list>.selected:not(.no-outline):focus{background-color:transparent}.list-item{color:var(--cros-text-color-primary);min-height:36px}.padded{padding-inline-end:var(--dialog-horizontal-padding);padding-inline-start:var(--dialog-horizontal-padding)}paper-ripple{color:var(--cros-menu-item-ripple-color)}</style>

<cr-dialog id="changeDictationLocaleDialog" close-text="$i18n{close}"
    show-on-attach>
  <div slot="title">$i18n{dictationChangeLanguageDialogTitle}</div>
  <div id="dialogBody" slot="body" scrollable>
    <cr-search-field label="$i18n{dictationChangeLanguageDialogSearchHint}"
        id="search" on-search-changed="onSearchChanged_"
        clear-label="$i18n{dictationChangeLanguageDialogSearchClear}"
        on-keydown="onKeydown_" autofocus>
    </cr-search-field>
    <h3 class="padded" hidden$="[[recommendedLocalesEmpty_]]">
      $i18n{dictationChangeLanguageDialogRecommended}
    </h3>
    <iron-list id="recommendedLocalesList"
        items="[[recommendedLocales_]]" selection-enabled
        selected-item="{{selectedRecommendedLocale_}}"
        on-selected-item-changed="selectedRecommendedLocaleChanged_"
        hidden$="[[recommendedLocalesEmpty_]]"
        scroll-target="[[$$('[slot=body]')]]">
      <template>
        <!-- |selected| is a property of iron-list -->
        <div class$="list-item [[getItemClass_(selected)]]" role="button"
            tabindex$="[[tabIndex]]"
            aria-label="[[getAriaLabelForItem_(item, selected)]]">
          <paper-ripple></paper-ripple>
          <div class="flex padded" aria-hidden="true">
            [[item.name]]
            <div class="subtitle" hidden="[[!item.worksOffline]]">
              $i18n{dictationLocaleOfflineSubtitle}
            </div>
          </div>
          <iron-icon icon="cr:check-circle"
              class$="[[getIconClass_(item, selected)]]">
          </iron-icon>
        </div>
      </template>
    </iron-list>
    <h3 class="padded" hidden$="[[displayedLocalesEmpty_]]">
      $i18n{dictationChangeLanguageDialogAll}
    </h3>
    <iron-list id="allLocalesList"
        items="[[displayedLocales_]]" selection-enabled
        selected-item="{{selectedLocale_}}"
        on-selected-item-changed="selectedLocaleChanged_"
        hidden$="[[displayedLocalesEmpty_]]"
        scroll-target="[[$$('[slot=body]')]]">
      <template>
        <div class$="list-item [[getItemClass_(selected)]]" role="button"
            tabindex$="[[tabIndex]]"
            aria-label="[[getAriaLabelForItem_(item, selected)]]">
          <paper-ripple></paper-ripple>
          <div class="flex padded" aria-hidden="true">
            [[item.name]]
            <div class="subtitle" hidden="[[!item.worksOffline]]">
              $i18n{dictationLocaleOfflineSubtitle}
            </div>
          </div>
          <iron-icon icon="cr:check-circle"
              class$="[[getIconClass_(item, selected)]]">
          </iron-icon>
        </div>
      </template>
    </iron-list>
    <div id="no-search-results" class="centered-message"
        hidden$="[[!displayedLocalesEmpty_]]">
      $i18n{dictationChangeLanguageDialogNoResults}
    </div>
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button" on-click="onCancelClick_">
      $i18n{dictationChangeLanguageDialogCancelButton}
    </cr-button>
    <cr-button id="update" class="action-button" on-click="onUpdateClick_"
        disabled="[[disableUpdateButton_]]">
      $i18n{dictationChangeLanguageDialogUpdateButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
