import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-section-indent-width:60px}.sub-item{padding-inline-start:var(--cr-section-indent-width)}.short{min-height:44px}.visually-hidden{clip:rect(0 0 0 0);clip-path:inset(50%);height:1px;overflow:hidden;position:absolute;white-space:nowrap;width:1px}settings-toggle-button,cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}</style>

<!-- TODO(b:341770655): Investigate whether the speed sliders should be
     refactored to a custom element. -->

<settings-card header-text="$i18n{faceGazeCursorSectionTitle}">
  <settings-toggle-button
      id="faceGazeCursorControlEnabledButton"
      label="$i18n{faceGazeCursorControlEnabledLabel}"
      pref="{{prefs.settings.a11y.face_gaze.cursor_control_enabled_sentinel}}">
  </settings-toggle-button>
  <div class="settings-box short">
    $i18n{faceGazeCursorSpeedSectionName}
  </div>
  <settings-toggle-button
      class="sub-item short"
      id="faceGazeCursorAdjustSeparatelyButton"
      label="$i18n{faceGazeCursorAdjustSeparatelyLabel}"
      pref="{{prefs.settings.a11y.face_gaze.adjust_speed_separately}}">
  </settings-toggle-button>
  <template is="dom-if"
        if="[[!prefs.settings.a11y.face_gaze.adjust_speed_separately.value]]">
    <div class="settings-box sub-item">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{faceGazeCursorSpeedLabel}
      </div>
      <settings-slider
          id="combinedSpeedSlider"
          pref="{{syntheticCombinedCursorSpeedPref_}}"
          min="[[minCursorSpeed]]" max="[[maxCursorSpeed]]"
          ticks="[[cursorSpeedTicks]]"
          label-aria="$i18n{faceGazeCursorSpeedLabel}"
          label-min="$i18n{faceGazeCursorSpeedSlow}"
          label-max="$i18n{faceGazeCursorSpeedFast}">
      </settings-slider>
    </div>
  </template>
  <template is="dom-if"
      if="[[prefs.settings.a11y.face_gaze.adjust_speed_separately.value]]"
      restamp>
    <div class="settings-box sub-item">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{faceGazeCursorUpSpeedLabel}
      </div>
      <settings-slider
          id="speedUpSlider"
          pref="{{prefs.settings.a11y.face_gaze.cursor_speed_up}}"
          min="[[minCursorSpeed]]" max="[[maxCursorSpeed]]"
          ticks="[[cursorSpeedTicks]]"
          label-aria="$i18n{faceGazeCursorUpSpeedLabel}"
          label-min="$i18n{faceGazeCursorSpeedSlow}"
          label-max="$i18n{faceGazeCursorSpeedFast}">
      </settings-slider>
    </div>
    <div class="settings-box sub-item">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{faceGazeCursorDownSpeedLabel}
      </div>
      <settings-slider
          id="speedDownSlider"
          pref="{{prefs.settings.a11y.face_gaze.cursor_speed_down}}"
          min="[[minCursorSpeed]]" max="[[maxCursorSpeed]]"
          ticks="[[cursorSpeedTicks]]"
          label-aria="$i18n{faceGazeCursorDownSpeedLabel}"
          label-min="$i18n{faceGazeCursorSpeedSlow}"
          label-max="$i18n{faceGazeCursorSpeedFast}">
      </settings-slider>
    </div>
    <div class="settings-box sub-item">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{faceGazeCursorLeftSpeedLabel}
      </div>
      <settings-slider
          id="speedLeftSlider"
          pref="{{prefs.settings.a11y.face_gaze.cursor_speed_left}}"
          min="[[minCursorSpeed]]" max="[[maxCursorSpeed]]"
          ticks="[[cursorSpeedTicks]]"
          label-aria="$i18n{faceGazeCursorLeftSpeedLabel}"
          label-min="$i18n{faceGazeCursorSpeedSlow}"
          label-max="$i18n{faceGazeCursorSpeedFast}">
      </settings-slider>
      </div>
      <div class="settings-box sub-item">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{faceGazeCursorRightSpeedLabel}
      </div>
      <settings-slider
          id="speedRightSlider"
          pref="{{prefs.settings.a11y.face_gaze.cursor_speed_right}}"
          min="[[minCursorSpeed]]" max="[[maxCursorSpeed]]"
          ticks="[[cursorSpeedTicks]]"
          label-aria="$i18n{faceGazeCursorRightSpeedLabel}"
          label-min="$i18n{faceGazeCursorSpeedSlow}"
          label-max="$i18n{faceGazeCursorSpeedFast}">
      </settings-slider>
    </div>
  </template>
  <div class="settings-box">
    <div class="start settings-box-text">
      <div class="label" aria-hidden="true" id="faceGazeVelocityThresholdLabel">
        $i18n{faceGazeCursorVelocityThresholdSliderPrimaryLabel}
      </div>
      <div class="secondary label" aria-hidden="true">
        $i18n{faceGazeCursorVelocityThresholdSliderSecondaryLabel}
      </div>
    </div>
    <settings-slider
        id="velocityThresholdSlider"
        pref="{{prefs.settings.a11y.face_gaze.velocity_threshold}}"
        min="[[minCursorTuning]]" max="[[maxCursorTuning]]"
        ticks="[[velocityThresholdTicks]]"
        label-aria="$i18n{faceGazeCursorVelocityThresholdSliderPrimaryLabel}"
        label-min="$i18n{faceGazeCursorVelocityThresholdSliderMinLabel}"
        label-max="$i18n{faceGazeCursorVelocityThresholdSliderMaxLabel}">
    </settings-slider>
  </div>
  <settings-toggle-button
      class="hr"
      id="accelerationButton"
      label="$i18n{faceGazeCursorAccelerationLabel}"
      sub-label="$i18n{faceGazeCursorAccelerationDescription}"
      pref="{{prefs.settings.a11y.face_gaze.cursor_use_acceleration}}">
  </settings-toggle-button>
  <settings-toggle-button
      class="hr"
      id="faceGazePrecisionClickButton"
      label="$i18n{faceGazePrecisionClickLabel}"
      sub-label="$i18n{faceGazePrecisionClickDescription}"
      pref="{{prefs.settings.a11y.face_gaze.precision_click}}">
  </settings-toggle-button>
  <template is="dom-if"
        if="[[prefs.settings.a11y.face_gaze.precision_click.value]]" restamp>
    <div class="settings-box sub-item">
      <div class="start settings-box-text" id="precisionClickSpeedFactorsLabel">
        $i18n{precisionClickSpeedFactorsLabel}
      </div>
      <settings-dropdown-menu id="precisionClickSpeedFactorsDropdown"
          aria-labelledby="precisionClickSpeedFactorsLabel"
          pref="{{prefs.settings.a11y.face_gaze.precision_click_speed_factor}}"
          menu-options="[[precisionClickSpeedFactorOptions_]]">
      </settings-dropdown-menu>
    </div>
  </template>
  <div class="settings-box">
    <template is="dom-if" if="[[shouldAnnounceA11yCursorSettingsReset_]]"
        restamp>
      <span id="cursorSettingsResetAlert" role="alert" class="visually-hidden">
        [[resetAlert_]]
      </span>
    </template>
    <cr-button
        id="cursorResetButton"
        class="button"
        on-focus="onFaceGazeCursorResetButtonFocus_"
        on-click="onFaceGazeCursorResetButtonClick_">
      $i18n{faceGazeCursorSettingsReset}
    </cr-button>
  </div>
</settings-card>
<!--_html_template_end_-->`;
}
