// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance = null;
export class FaceGazeSubpageBrowserProxyImpl {
    static getInstance() {
        return instance || (instance = new FaceGazeSubpageBrowserProxyImpl());
    }
    static setInstanceForTesting(obj) {
        instance = obj;
    }
    requestEnableFaceGaze(enable) {
        chrome.send('requestEnableFaceGaze', [enable]);
    }
    toggleGestureInfoForSettings(enabled) {
        chrome.send('toggleGestureInfoForSettings', [enabled]);
    }
}
