import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-section-indent-width:60px}.sub-item{padding-inline-start:var(--cr-section-indent-width)}settings-toggle-button,cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}.settings-box.indented,settings-toggle-button.indented{margin-inline-start:var(--cr-section-indent-width)}#screenMagnifierZoomHintLabel{white-space:pre-line}#dictationLocaleMenuSubtitle{max-width:450px;overflow-wrap:break-word}</style>

<settings-toggle-button
    icon="os-settings:on-screen-keyboard"
    pref="{{prefs.settings.a11y.virtual_keyboard}}"
    label="$i18n{onScreenKeyboardLabel}"
    sub-label="$i18n{onScreenKeyboardDescription}"
    deep-link-focus-id$="[[Setting.kOnScreenKeyboard]]">
</settings-toggle-button>
<settings-toggle-button
    id="enableDictation"
    class="hr"
    icon="os-settings:dictation"
    pref="{{prefs.settings.a11y.dictation}}"
    label="$i18n{dictationLabel}"
    sub-label="$i18n{dictationDescription}"
    deep-link-focus-id$="[[Setting.kDictation]]"
    learn-more-url="[[dictationLearnMoreUrl_]]">
</settings-toggle-button>
<template is="dom-if" if="[[prefs.settings.a11y.dictation.value]]">
  <div class="settings-box indented">
    <div class="flex start settings-box-text" id="labelWrapper">
      <div class="label" aria-hidden="true" id="dictationLocaleMenuLabel">
          $i18n{dictationLocaleMenuLabel}
      </div>
      <div class="secondary label" id="dictationLocaleMenuSubtitle">
          [[dictationLocaleMenuSubtitle_]]
      </div>
    </div>
    <cr-button on-click="onChangeDictationLocaleButtonClicked_">
      $i18n{dictationChangeLanguageButton}
    </cr-button>
    <template is="dom-if" if="[[showDictationLocaleMenu_]]" restamp>
      <os-settings-change-dictation-locale-dialog
        id="changeDictationLocaleDialog"
        pref="{{prefs.settings.a11y.dictation_locale}}"
        on-close="onChangeDictationLocalesDialogClosed_"
        options="[[dictationLocaleOptions_]]">
      </os-settings-change-dictation-locale-dialog>
    </template>
  </div>
</template>
<settings-toggle-button
    id="enableSwitchAccess"
    class="hr"
    icon="os-settings:switch-access"
    pref="{{prefs.settings.a11y.switch_access.enabled}}"
    label="$i18n{switchAccessLabel}"
    sub-label="$i18n{switchAccessLabelSubtext}"
    deep-link-focus-id$="[[Setting.kEnableSwitchAccess]]">
</settings-toggle-button>
<iron-collapse
    opened="[[prefs.settings.a11y.switch_access.enabled.value]]">
  <div class="sub-item">
    <cr-link-row id="switchAccessSubpageButton"
        class="settings-box"
        label="$i18n{switchAccessOptionsLabel}"
        on-click="onSwitchAccessSettingsClick_"
        role-description="$i18n{subpageArrowRoleDescription}" embedded>
    </cr-link-row>
  </div>
</iron-collapse>
<settings-toggle-button
    id="stickyKeysToggle"
    class="hr"
    pref="[[stickyKeysEnabledVirtualPref_]]"
    no-set-pref
    on-settings-boolean-control-change="updateStickyKeysEnabledVirtualPref_"
    label="$i18n{stickyKeysLabel}"
    sub-label="$i18n{stickyKeysDescription}"
    disabled="[[prefs.settings.accessibility.value]]"
    deep-link-focus-id$="[[Setting.kStickyKeys]]">
  <cr-tooltip-icon
      id="stickyKeysDisabledTooltip"
      hidden$="[[!prefs.settings.accessibility.value]]"
      tooltip-text="$i18n{stickyKeysDisabledByChromevoxTooltip}"
      icon-class="cr:info-outline"
      slot="more-actions">
  </cr-tooltip-icon>
</settings-toggle-button>
<settings-toggle-button
    id="focusHighlightToggle"
    class="hr"
    pref="[[focusHighlightEnabledVirtualPref_]]"
    no-set-pref
    on-settings-boolean-control-change="updateFocusHighlightEnabledVirtualPref_"
    label="$i18n{focusHighlightLabel}"
    sub-label="$i18n{focusHighlightLabelSubtext}"
    disabled="[[prefs.settings.accessibility.value]]"
    deep-link-focus-id$="[[Setting.kHighlightKeyboardFocus]]">
  <cr-tooltip-icon
      id="focusHighlightDisabledTooltip"
      hidden$="[[!prefs.settings.accessibility.value]]"
      tooltip-text="$i18n{focusHighlightDisabledByChromevoxTooltip}"
      icon-class="cr:info-outline"
      slot="more-actions">
  </cr-tooltip-icon>
</settings-toggle-button>
<settings-toggle-button
    id="caretHighlightToggle"
    class="hr"
    pref="{{prefs.settings.a11y.caret_highlight}}"
    label="$i18n{caretHighlightLabel}"
    sub-label="$i18n{caretHighlightLabelSubtext}"
    deep-link-focus-id$="[[Setting.kHighlightTextCaret]]">
</settings-toggle-button>
<div class="settings-box" id="caretBlinkIntervalRow">
  <div class="flex start settings-box-text">
    <div class="label" aria-hidden="true">
      $i18n{caretBlinkIntervalLabel}
    </div>
  </div>
  <settings-slider
      id="caretBlinkIntervalSlider"
      pref="{{caretBlinkIntervalVirtualPref_}}"
      show-markers
      label-aria="$i18n{caretBlinkIntervalLabel}"
      label-min="$i18n{caretBlinkIntervalOff}"
      label-max="$i18n{caretBlinkIntervalFast}"
      ticks="[[computeCaretBlinkIntervalTicks_()]]"
      deep-link-focus-id$="[[Setting.kCaretBlinkInterval]]">
  </settings-slider>
</div>
<settings-toggle-button
    id="caretBrowsingToggle"
    class="hr"
    pref="{{prefs.settings.a11y.caretbrowsing.enabled}}"
    on-change="onA11yCaretBrowsingChange_"
    label="$i18n{caretBrowsingLabel}"
    sub-label="$i18n{caretBrowsingLabelSubtext}"
    deep-link-focus-id$="[[Setting.kCaretBrowsing]]">
</settings-toggle-button>
<template is="dom-if" if="[[isSlowKeysFeatureEnabled_]]">
  <settings-toggle-button
      id="slowKeysToggle"
      class="hr"
      pref="{{prefs.settings.a11y.slow_keys_enabled}}"
      label="$i18n{slowKeysLabel}"
      sub-label="$i18n{slowKeysDescription}"
      deep-link-focus-id$="[[Setting.kSlowKeys]]">
  </settings-toggle-button>
  <iron-collapse class="sub-item"
      opened="[[prefs.settings.a11y.slow_keys_enabled.value]]">
    <div class="settings-box">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{slowKeysDelayLabel}
      </div>
      <settings-slider
          id="slowKeysDelaySlider"
          pref="{{slowKeysDelayVirtualPref_}}"
          show-markers
          label-aria="$i18n{slowKeysDelayLabel}"
          label-min="$i18n{slowKeysDelaySliderShort}"
          label-max="$i18n{slowKeysDelaySliderLong}"
          ticks="[[computeSlowKeysDelayTicks_()]]"
          deep-link-focus-id$="[[Setting.kSlowKeysDelay]]">
      </settings-slider>
    </div>
  </iron-collapse>
</template>
<template is="dom-if" if="[[isBounceKeysFeatureEnabled_]]">
  <settings-toggle-button
      id="bounceKeysToggle"
      class="hr"
      pref="{{prefs.settings.a11y.bounce_keys_enabled}}"
      label="$i18n{bounceKeysLabel}"
      sub-label="$i18n{bounceKeysDescription}"
      deep-link-focus-id$="[[Setting.kBounceKeys]]">
  </settings-toggle-button>
  <iron-collapse class="sub-item"
      opened="[[prefs.settings.a11y.bounce_keys_enabled.value]]">
    <div class="settings-box">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{bounceKeysDelayLabel}
      </div>
      <settings-slider
          id="bounceKeysDelaySlider"
          pref="{{bounceKeysDelayVirtualPref_}}"
          show-markers
          label-aria="$i18n{bounceKeysDelayLabel}"
          label-min="$i18n{bounceKeysDelaySliderShort}"
          label-max="$i18n{bounceKeysDelaySliderLong}"
          ticks="[[computeBounceKeysDelayTicks_()]]"
          deep-link-focus-id$="[[Setting.kBounceKeysDelay]]">
      </settings-slider>
    </div>
  </iron-collapse>
</template>
<template is="dom-if" if="[[!isKioskModeActive_]]">
  <cr-link-row id="keyboardSubpageButton" class="hr"
      label="$i18n{keyboardSettingsTitle}" on-click="onKeyboardClick_"
      sub-label="$i18n{keyboardSettingsDescription}"
      role-description="$i18n{subpageArrowRoleDescription}" embedded>
  </cr-link-row>
</template>
<!--_html_template_end_-->`;
}
