import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">settings-toggle-button{--cr-icon-button-margin-end:16px;--iron-icon-fill-color:var(--cros-sys-primary)}</style>

<os-settings-animated-pages id="pages"
    current-route="{{currentRoute}}"
    section="[[section_]]">
  <div route-path="default">
    <settings-card header-text="$i18n{a11yPageTitle}">
      <settings-toggle-button
          id="a11yImageLabelsToggle"
          icon="os-settings:a11y-image-description"
          hidden="[[!hasScreenReader_]]"
          pref="{{prefs.settings.a11y.enable_accessibility_image_labels}}"
          on-change="onToggleAccessibilityImageLabels_"
          label="$i18n{accessibleImageLabelsTitle}"
          sub-label="$i18n{accessibleImageLabelsSubtitle}"
          deep-link-focus-id$="[[Setting.kGetImageDescriptionsFromGoogle]]">
      </settings-toggle-button>
      <div class="hr" hidden="[[!hasScreenReader_]]"></div>
      <settings-toggle-button id="optionsInMenuToggle"
          icon="os-settings:accessibility"
          label="$i18n{optionsInMenuLabel}"
          sub-label="$i18n{optionsInMenuDescription}"
          pref="{{prefs.settings.a11y.enable_menu}}"
          deep-link-focus-id$="[[Setting.kA11yQuickSettings]]">
      </settings-toggle-button>
      <div class="hr"></div>
      <cr-link-row id="textToSpeechSubpageTrigger"
          start-icon="os-settings:text-to-speech"
          label="$i18n{textToSpeechLinkTitle}"
          on-click="onTextToSpeechClick_"
          sub-label="$i18n{textToSpeechLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <div class="hr"></div>
      <cr-link-row id="displayAndMagnificationPageTrigger"
          start-icon="os-settings:zoom-in"
          label="$i18n{displayAndMagnificationLinkTitle}"
          on-click="onDisplayAndMagnificationClick_"
          sub-label="$i18n{displayAndMagnificationLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <div class="hr"></div>
      <cr-link-row id="keyboardAndTextInputPageTrigger"
          start-icon="os-settings:a11y-keyboard-and-text-input"
          label="$i18n{keyboardAndTextInputLinkTitle}"
          on-click="onKeyboardAndTextInputClick_"
          sub-label="$i18n{keyboardAndTextInputLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <div class="hr"></div>
      <cr-link-row id="cursorAndTouchpadPageTrigger"
          start-icon="os-settings:cursor-click"
          label="$i18n{cursorAndTouchpadLinkTitle}"
          on-click="onCursorAndTouchpadClick_"
          sub-label="$i18n{cursorAndTouchpadLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <div class="hr"></div>
      <cr-link-row id="audioAndCaptionsPageTrigger"
          start-icon="os-settings:a11y-hearing"
          label="$i18n{audioAndCaptionsLinkTitle}"
          on-click="onAudioAndCaptionsClick_"
          sub-label="$i18n{audioAndCaptionsLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <template is="dom-if" if="[[!isGuest_]]">
        <cr-link-row
            id="additionalFeaturesLink" class="hr"
            start-icon="os-settings:a11y-find-more"
            label="$i18n{additionalFeaturesTitle}"
            on-click="onAdditionalFeaturesClick_"
            external>
        </cr-link-row>
      </template>
      <cr-link-row
          id="disabilitySupportLink" class="hr"
          start-icon="os-settings:a11y-contact-support"
          label="$i18n{disabilitySupportTitle}"
          on-click="onDisabilitySupportClick_"
          external>
      </cr-link-row>
    </settings-card>
  </div>

  <template is="dom-if" route-path="/manageAccessibility">
    <os-settings-subpage page-title="$i18n{manageAccessibilityFeatures}"
        hide-back-button>
      <settings-toggle-button
          id="a11yImageLabelsToggle"
          hidden="[[!hasScreenReader_]]"
          pref="{{prefs.settings.a11y.enable_accessibility_image_labels}}"
          on-change="onToggleAccessibilityImageLabels_"
          label="$i18n{accessibleImageLabelsTitle}"
          sub-label="$i18n{accessibleImageLabelsSubtitle}"
          deep-link-focus-id$="[[Setting.kGetImageDescriptionsFromGoogle]]">
      </settings-toggle-button>
      <div class="hr" hidden="[[!hasScreenReader_]]"></div>
      <cr-link-row id="textToSpeechSubpageTrigger"
          label="$i18n{textToSpeechLinkTitle}"
          on-click="onTextToSpeechClick_"
          sub-label="$i18n{textToSpeechLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <div class="hr"></div>
      <cr-link-row id="displayAndMagnificationPageTrigger"
          label="$i18n{displayAndMagnificationLinkTitle}"
          on-click="onDisplayAndMagnificationClick_"
          sub-label="$i18n{displayAndMagnificationLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <div class="hr"></div>
      <cr-link-row id="keyboardAndTextInputPageTrigger"
          label="$i18n{keyboardAndTextInputLinkTitle}"
          on-click="onKeyboardAndTextInputClick_"
          sub-label="$i18n{keyboardAndTextInputLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <div class="hr"></div>
      <cr-link-row id="cursorAndTouchpadPageTrigger"
          label="$i18n{cursorAndTouchpadLinkTitle}"
          on-click="onCursorAndTouchpadClick_"
          sub-label="$i18n{cursorAndTouchpadLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <div class="hr"></div>
      <cr-link-row id="audioAndCaptionsPageTrigger"
          label="$i18n{audioAndCaptionsLinkTitle}"
          on-click="onAudioAndCaptionsClick_"
          sub-label="$i18n{audioAndCaptionsLinkDescription}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/textToSpeech">
    <os-settings-subpage page-title="$i18n{textToSpeechLinkTitle}">
      <settings-text-to-speech-subpage prefs="{{prefs}}"
          has-screen-reader="[[hasScreenReader_]]">
      </settings-text-to-speech-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/textToSpeech/chromeVox">
    <os-settings-subpage page-title="$i18n{chromeVoxLabel}">
      <settings-chromevox-subpage prefs="{{prefs}}">
      </settings-chromevox-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/textToSpeech/selectToSpeak">
    <os-settings-subpage page-title="$i18n{selectToSpeakLinkTitle}">
      <settings-select-to-speak-subpage prefs="{{prefs}}">
      </settings-select-to-speak-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/displayAndMagnification">
    <os-settings-subpage page-title="$i18n{displayAndMagnificationLinkTitle}">
      <settings-display-and-magnification-subpage prefs="{{prefs}}">
      </settings-display-and-magnification-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/keyboardAndTextInput">
    <os-settings-subpage page-title="$i18n{keyboardAndTextInputLinkTitle}">
      <settings-keyboard-and-text-input-page prefs="{{prefs}}">
      </settings-keyboard-and-text-input-page>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/cursorAndTouchpad">
    <os-settings-subpage page-title="$i18n{cursorAndTouchpadLinkTitle}">
      <settings-cursor-and-touchpad-page prefs="{{prefs}}">
      </settings-cursor-and-touchpad-page>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/audioAndCaptions">
    <os-settings-subpage page-title="$i18n{audioAndCaptionsLinkTitle}">
      <settings-audio-and-captions-page prefs="{{prefs}}"
          languages="[[languages]]"
          language-helper="[[languageHelper]]">
      </settings-audio-and-captions-page>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/manageAccessibility/tts">
    <os-settings-subpage page-title="$i18n{manageTtsSettings}">
      <settings-tts-voice-subpage prefs="{{prefs}}">
      </settings-tts-voice-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/manageAccessibility/captions">
    <os-settings-subpage page-title="$i18n{captionsTitle}">
      <settings-captions prefs="{{prefs}}"
          languages="[[languages]]"
          language-helper="[[languageHelper]]">
      </settings-captions>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/manageAccessibility/switchAccess">
    <os-settings-subpage page-title="$i18n{manageSwitchAccessSettings}">
      <settings-switch-access-subpage prefs="{{prefs}}">
      </settings-switch-access-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/manageAccessibility/faceGaze">
    <os-settings-subpage page-title="$i18n{accessibilityFaceGazeLabel}"
        multi-card>
      <settings-facegaze-subpage prefs="{{prefs}}">
      </settings-facegaze-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/manageAccessibility/mouseKeys">
    <os-settings-subpage page-title="$i18n{mouseKeysLabel}"
        multi-card>
      <settings-mouse-keys-subpage prefs="{{prefs}}">
      </settings-mouse-keys-subpage>
    </os-settings-subpage>
  </template>
</os-settings-animated-pages>
<!--_html_template_end_-->`;
}
