import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="settings-shared">:host{--cr-section-indent-width:60px;--focus-ring-highlight-color:rgb(218,54,232)}h2{padding-inline-start:var(--cr-section-padding)}.sub-item{padding-inline-start:var(--cr-section-indent-width)}.indented{margin-inline-start:32px}.settings-box{margin-inline-end:var(--cr-section-padding);padding-inline-end:0;padding-inline-start:0}settings-dropdown-menu{--md-select-width:100%}settings-toggle-button,cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}.preview-input{width:315px;--cr-input-error-display:none}.preview-input cr-button{margin-inline-start:8px}.highlight-example-container{display:flex;flex-direction:row;justify-content:space-between;margin-inline-end:var(--cr-section-padding)}.example{display:flex;flex:1;font-size:1em;height:60px;justify-content:center;line-height:60px;padding:0 3px;vertical-align:middle}.example.light{background-color:var(--cros-bg-color-light);border-radius:4px 0 0 4px;color:var(--cros-text-color-primary-light)}.example.dark{background-color:var(--cros-bg-color-dark);border-radius:0 4px 4px 0;color:var(--cros-text-color-primary-dark)}.highlight{height:20px;opacity:.3;position:relative;top:-40px;width:100%;z-index:10}.background-preview{background-color:rgba(var(--cros-bg-color-dark-rgb),.4);border-radius:4px;line-height:1.5;margin-inline-end:var(--cr-section-padding);margin-top:16px;padding:16px 24px 16px 24px;position:relative}.background-preview-selected{background-color:var(--cros-bg-color);border-radius:6px;box-shadow:0 0 4px 4px var(--focus-ring-highlight-color);color:var(--cros-text-color-primary);display:inline-block;margin:0;padding:6px 4px 6px 4px}.background-preview-unselected{color:var(--cros-text-color-secondary);margin:2px 0 2px 0;padding:0 4px 0 4px}</style>

<h2>$i18n{selectToSpeakOptionsSpeech}</h2>
<div class="sub-item">
  <div class="settings-box continuation">
    <div class="start settings-box-text">
      $i18n{selectToSpeakOptionsLanguagesFilterDescription}
    </div>
    <settings-dropdown-menu
        label="$i18n{selectToSpeakOptionsLanguagesFilterDescription}"
        pref="{{languageFilterVirtualPref_}}"
        menu-options="[[languagesMenuOptions_]]">
    </settings-dropdown-menu>
  </div>
  <div class="settings-box">
    <div class="start settings-box-text">
      $i18n{selectToSpeakOptionsVoiceDescription}
    </div>
    <settings-dropdown-menu id="voiceDropdown"
        label="$i18n{selectToSpeakOptionsVoiceDescription}"
        pref="{{prefs.settings.a11y.select_to_speak_voice_name}}"
        menu-options="[[localVoicesMenuOptions_]]"
        deep-link-focus-id$="[[Setting.kSelectToSpeakVoice]]">
      </settings-dropdown-menu>
  </div>
  <div class="settings-box">
    <div id="voicePreview" class="start settings-box-text">
      $i18n{selectToSpeakOptionsVoicePreview}
    </div>
    <cr-input id="voicePreviewInput"
        class="preview-input"
        aria-labelledby="voicePreview"
        value="{{voicePreviewText_}}"
        disabled="[[isPreviewing_]]">
      <cr-button id="voicePreviewButton"
          on-click="onVoicePreviewClick_"
          disabled$="[[!enablePreviewButton_(localVoicesMenuOptions_,
                       isPreviewing_,
                       voicePreviewText_)]]"
          slot="suffix">
        $i18n{textToSpeechPreviewPlay}
      </cr-button>
    </cr-input>
  </div>
  <cr-link-row class="settings-box"
      label="$i18n{selectToSpeakTextToSpeechSettingsLink}"
      on-click="onTextToSpeechSettingsClick_"
      aria-show-label aria-show-sublabel
      embedded>
  </cr-link-row>
  <settings-toggle-button
      id="voiceSwitchingToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.select_to_speak_voice_switching}}"
      label="$i18n{selectToSpeakOptionsVoiceSwitchingDescription}"
      deep-link-focus-id$="[[Setting.kSelectToSpeakVoiceSwitching]]"
      disabled="[[prefs.settings.a11y.select_to_speak_enhanced_network_voices.value]]"
      aria-show-label aria-show-sublabel>
  </settings-toggle-button>
  <settings-toggle-button
      id="enhancedNetworkVoicesToggle"
      class="settings-box"
      pref="[[enhancedNetworkVoicesVirtualPref_]]"
      label="$i18n{selectToSpeakOptionsEnhancedNetworkVoicesDescription}"
      sub-label="$i18n{selectToSpeakOptionsEnhancedNetworkVoicesSubtitle}"
      learn-more-url="[[selectToSpeakLearnMoreUrl_]]"
      on-settings-boolean-control-change="onEnhancedNetworkVoicesToggleChanged_"
      deep-link-focus-id$="[[Setting.kSelectToSpeakEnhancedNetworkVoices]]"
      disabled="[[prefs.settings.a11y.select_to_speak_voice_switching.value]]"
      aria-show-label aria-show-sublabel
      no-set-pref>
  </settings-toggle-button>
    <template is="dom-if" if="[[enhancedNetworkVoicesVirtualPref_.value]]">
      <div class="indented" id="enhancedNetworkVoiceControls">
        <div class="settings-box">
          <div class="start settings-box-text">
            $i18n{selectToSpeakOptionsEnhancedNetworkVoice}
          </div>
          <settings-dropdown-menu id="enhancedNetworkVoiceDropdown"
              class="continuation"
              label="$i18n{selectToSpeakOptionsEnhancedNetworkVoice}"
              pref="{{prefs.settings.a11y.select_to_speak_enhanced_voice_name}}"
              menu-options="[[networkVoicesMenuOptions_]]"
              deep-link-focus-id$="[[Setting.kSelectToSpeakEnhancedNetworkVoice]]">
          </settings-dropdown-menu>
        </div>
        <div class="settings-box">
          <div id="enhancedNetworkVoicePreview" class="start settings-box-text">
            $i18n{selectToSpeakOptionsNaturalVoicePreview}
          </div>
          <cr-input id="enhancedNetworkVoicePreviewInput"
              class="preview-input"
              aria-labelledby="enhancedNetworkVoicePreview"
              value="{{enhancedNetworkVoicePreviewText_}}"
              disabled="[[isPreviewing_]]">
            <cr-button id="enhancedNetworkVoicePreviewButton"
                on-click="onEnhancedNetworkVoicePreviewClick_"
                disabled$="[[!enablePreviewButton_(networkVoicesMenuOptions_,
                            isPreviewing_,
                            enhancedNetworkVoicePreviewText_)]]"
                slot="suffix">
              $i18n{textToSpeechPreviewPlay}
            </cr-button>
          </cr-input>
        </div>
      </div>
    </template>
  </template>
</div>

<h2>$i18n{selectToSpeakOptionsHighlight}</h2>
<div class="highlight-example-container sub-item">
  <div class="example light">
    <div>
      <span>$i18n{selectToSpeakOptionsHighlightLight}</span>
      <div id="lightHighlight" class="highlight"></div>
    </div>
  </div>
  <div class="example dark">
    <div>
      <span>$i18n{selectToSpeakOptionsHighlightDark}</span>
      <div id="darkHighlight" class="highlight"></div>
    </div>
  </div>
</div>
<div class="sub-item">
  <settings-toggle-button
      id="wordHighlightToggle"
      class="settings-box continuation"
      pref="{{prefs.settings.a11y.select_to_speak_word_highlight}}"
      label="$i18n{selectToSpeakOptionsHighlightDescription}"
      deep-link-focus-id$="[[Setting.kSelectToSpeakWordHighlight]]"
      aria-show-label aria-show-sublabel>
  </settings-toggle-button>
  <template is="dom-if"
      if="[[prefs.settings.a11y.select_to_speak_word_highlight.value]]">
    <div class="indented">
      <div class="settings-box continuation">
        <div class="start settings-box-text">
          $i18n{selectToSpeakOptionsHighlightColorDescription}
        </div>
        <settings-dropdown-menu id="highlightColorDropdown"
            label="$i18n{selectToSpeakOptionsHighlightColorDescription}"
            pref="{{prefs.settings.a11y.select_to_speak_highlight_color}}"
            menu-options="[[highlightColorOptions_]]">
        </settings-dropdown-menu>
      </div>
    </div>
  </template>
  <div class="background-preview">
    <p class="background-preview-unselected">
      $i18n{selectToSpeakOptionsSampleText}
    </p>
    <p class="background-preview-selected">
      $i18n{selectToSpeakOptionsSampleText}
    </p>
    <p class="background-preview-unselected">
      $i18n{selectToSpeakOptionsSampleText}
    </p>
  </div>
  <settings-toggle-button
      id="backgroundShadingToggle"
      class="settings-box continuation"
      pref="{{prefs.settings.a11y.select_to_speak_background_shading}}"
      label="$i18n{selectToSpeakOptionsBackgroundShadingDescription}"
      deep-link-focus-id$="[[Setting.kSelectToSpeakBackgroundShading]]"
      aria-show-label aria-show-sublabel>
  </settings-toggle-button>
</div>
<settings-toggle-button
    id="navigationControlsToggle"
    class="hr"
    pref="{{prefs.settings.a11y.select_to_speak_navigation_controls}}"
    label="$i18n{selectToSpeakOptionsNavigationControlsDescription}"
    sub-label="$i18n{selectToSpeakOptionsNavigationControlsSubtitle}"
    deep-link-focus-id$="[[Setting.kSelectToSpeakNavigationControls]]"
    aria-show-label aria-show-sublabel>
</settings-toggle-button>
<!--_html_template_end_-->`;
}
