import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><link rel="import" href="chrome://resources/ash/common/cr_elements/cr_icons.css.html">
<style include="cr-shared-style settings-shared">cr-dialog::part(dialog){height:380px;width:600px}.sa-setup-title{line-height:150%}.sa-setup-body{height:233px;margin-top:5px}.sa-setup-contents{width:335px}.flex{display:flex;flex-direction:row;justify-content:space-between}.illustration{height:173px;margin-top:15px;padding:16px;width:183px}#buttonContainer{padding:24px}cr-button{margin:4px}.radio-button-title{color:var(--cr-primary-text-color);font-size:14px}.radio-button-description{padding-bottom:16px}#bluetooth{margin-inline-end:324px}#exit{float:right;margin-top:-6px;padding:none}</style>
<cr-dialog id="switchAccessSetupGuideDialog" show-on-attach>
  <div slot="title" class="sa-setup-title" id="title">
    <span id="titleText">
      $i18n{switchAccessSetupIntroTitle}
    </span>
    <cr-icon-button iron-icon="cr:close" id="exit" on-click="onExitClick_">
    </cr-icon-button>
  </div>
  <div slot="body" class="sa-setup-body">
    <div id="intro" class="flex">
      <div class="sa-setup-contents">
        $i18n{switchAccessSetupIntroBody}
      </div>

      <iron-icon icon="os-settings-illo:switch-access-setup-guide-start-pairing"
          class="illustration">
      </iron-icon>
    </div>
    <div id="assignSwitch" class="flex" hidden
        data-switch$="[[switchToAssign_]]">
      <div class="sa-setup-contents"></div>

      <iron-icon icon="[[getAssignSwitchIllo_(switchToAssign_)]]"
          class="illustration">
      </iron-icon>
    </div>
    <div id="autoScanEnabled" class="flex" hidden>
      <div class="sa-setup-contents">
        <p>$i18n{switchAccessSetupAutoScanEnabledExplanation}</p>
        <p>$i18n{switchAccessSetupAutoScanEnabledDirections}</p>
      </div>

      <iron-icon icon="os-settings-illo:switch-access-setup-guide-auto-scan"
          class="illustration">
      </iron-icon>
    </div>
    <div id="chooseSwitchCount" class="flex" hidden
        data-switch-count$="[[switchCount_]]">
      <div class="sa-setup-contents">
        <cr-radio-group id="switchCountGroup" selected="one-switch"
            on-selected-changed="onSwitchCountChanged_">
          <cr-radio-button name="one-switch" class="list-item"
              aria-label="$i18n{switchAccessSetupChoose1Switch}">
            <span class="radio-button-title">
              $i18n{switchAccessSetupChoose1Switch}
            <span>
          </cr-radio-button>
          <cr-radio-button name="two-switches" class="list-item"
              aria-label="$i18n{switchAccessSetupChoose2Switches}">
            <span class="radio-button-title">
              $i18n{switchAccessSetupChoose2Switches}
            </span>
            <div class="radio-button-description">
              $i18n{switchAccessSetupChoose2SwitchesDescription}
            </div>
          </cr-radio-button>
          <cr-radio-button name="three-switches" class="list-item"
              aria-label="$i18n{switchAccessSetupChoose3Switches}">
            <span class="radio-button-title">
              $i18n{switchAccessSetupChoose3Switches}
            </span>
            <div class="radio-button-description">
              $i18n{switchAccessSetupChoose3SwitchesDescription}
            </div>
          </cr-radio-button>
        </cr-radio-button-group>
      </div>

      <iron-icon icon="[[getSwitchCountIllo_(switchCount_)]]"
          class="illustration">
      </iron-icon>
    </div>
    <div id="autoScanSpeed" hidden>
      <p>$i18n{switchAccessSetupAutoScanSpeedDescription}</p>
      <cr-button id="autoScanSpeedSlower" on-click="onAutoScanSpeedSlower_">
        $i18n{switchAccessSetupAutoScanSlower}
      </cr-button>
      <settings-slider id="autoScanSpeedSlider"
        pref="{{prefs.settings.a11y.switch_access.auto_scan.speed_ms}}"
        ticks="[[autoScanSpeedRangeMs_]]"
        min="[[minScanSpeedMs_]]"
        max="[[maxScanSpeedMs_]"
        label-aria="$i18n{switchAccessAutoScanSpeedLabel}"
        label-min="[[minScanSpeedLabelSec_]]"
        label-max="[[maxScanSpeedLabelSec_]]">
      </settings-slider>
      <cr-button id="autoScanSpeedFaster" on-click="onAutoScanSpeedFaster_">
        $i18n{switchAccessSetupAutoScanFaster}
      </cr-button>
    </div>
    <div id="closing" class="flex" hidden>
      <div class="sa-setup-contents">
        <p id="closingInstructions"></p>
        <p>$i18n{switchAccessSetupClosingInfo}</p>
      </div>

      <iron-icon icon="os-settings-illo:switch-access-setup-guide-closing"
          class="illustration">
      </iron-icon>
    </div>
  </div>
  <div id="buttonContainer" slot="button-container">
    <cr-button on-click="onBluetoothClick_" id="bluetooth">
      $i18n{switchAccessSetupPairBluetooth}
    </cr-button>
    <cr-button on-click="onPreviousClick_" id="previous" hidden>
      $i18n{switchAccessSetupPrevious}
    </cr-button>
    <cr-button on-click="onStartOverClick_" id="startOver" hidden>
      $i18n{switchAccessSetupStartOver}
    </cr-button>
    <cr-button class="action-button" on-click="onExitClick_"
        id="done" hidden>
      $i18n{switchAccessSetupDone}
    </cr-button>
    <cr-button class="action-button" on-click="onNextClick_" id="next">
      $i18n{switchAccessSetupNext}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
