import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">h2{padding-inline-start:var(--cr-section-padding)}ul{list-style-type:none;text-align:end}</style>
<cr-link-row
    on-click="onSetupGuideRerunClick_"
    label="$i18n{switchAccessSetupGuideLabel}" id="setupGuideLink">
</cr-link-row>
<template is="dom-if"
    if="[[showSwitchAccessSetupGuideWarningDialog_]]" restamp>
  <settings-switch-access-setup-guide-warning-dialog
      on-close="onSetupGuideWarningDialogClose_"
      on-cancel="onSetupGuideWarningDialogCancel_">
</template>
<template is="dom-if"
    if="[[showSwitchAccessSetupGuideDialog_]]" restamp>
  <settings-switch-access-setup-guide-dialog
      id="switchAccessSetupGuideDialog"
      prefs="{{prefs}}"
      on-close="onSwitchAccessSetupGuideDialogClose_">
  </settings-switch-access-setup-guide-dialog>
</template>
<h2>$i18n{switchAssignmentHeading}</h2>
<div class="list-frame">
    <cr-link-row on-click="onSelectAssignClick_"
        id="selectLinkRow"
        label="$i18n{assignSelectSwitchLabel}"
        sub-label="[[getAssignSwitchSubLabel_(selectAssignments_)]]"
        deep-link-focus-id$="[[Setting.kSwitchActionAssignment]]">
    </cr-link-row>
    <cr-link-row on-click="onNextAssignClick_"
        id="nextLinkRow"
        label="$i18n{assignNextSwitchLabel}"
        sub-label="[[getAssignSwitchSubLabel_(nextAssignments_)]]">
    </cr-link-row>
    <cr-link-row on-click="onPreviousAssignClick_"
        id="previousLinkRow"
        label="$i18n{assignPreviousSwitchLabel}"
        sub-label="[[getAssignSwitchSubLabel_(previousAssignments_)]]">
    </cr-link-row>
</div>
<template is="dom-if"
    if="[[showSwitchAccessActionAssignmentDialog_]]" restamp>
  <settings-switch-access-action-assignment-dialog
      id="switchAccessActionAssignmentDialog"
      on-close="onSwitchAccessActionAssignmentDialogClose_"
      action="[[action_]]">
  </settings-switch-access-action-assignment-dialog>
</template>
<h2>$i18n{switchAccessAutoScanHeading}</h2>
<div class="list-frame">
  <settings-toggle-button class="list-item"
      pref="{{prefs.settings.a11y.switch_access.auto_scan.enabled}}"
      label="$i18n{switchAccessAutoScanLabel}"
      deep-link-focus-id$="[[Setting.kSwitchActionAutoScan]]">
  </settings-toggle-button>
  <div class="settings-box continuation list-item" hidden$="[[
      !prefs.settings.a11y.switch_access.auto_scan.enabled.value]]">
    <div class="start sub-item settings-box-text" id="scanSpeed"
        aria-hidden="true">
      $i18n{switchAccessAutoScanSpeedLabel}
    </div>
    <settings-slider id="scanSpeedSlider"
        pref="{{prefs.settings.a11y.switch_access.auto_scan.speed_ms}}"
        ticks="[[autoScanSpeedRangeMs_]]"
        min="[[minScanSpeedMs_]]"
        max="[[maxScanSpeedMs_]]"
        label-aria="$i18n{switchAccessAutoScanSpeedLabel}"
        label-min="[[minScanSpeedLabelSec_]]"
        label-max="[[maxScanSpeedLabelSec_]]">
    </settings-slider>
  </div>
  <div class="settings-box continuation list-item"
      hidden$="[[!showKeyboardScanSettings_(
          prefs.settings.a11y.switch_access.auto_scan.enabled.value)]]">
    <div class="start sub-item settings-box-text" id="keyboardScanSpeed"
        aria-hidden="true">
      $i18n{switchAccessAutoScanKeyboardSpeedLabel}
    </div>
    <settings-slider id="keyboardScanSpeedSlider"
        pref="{{prefs.settings.a11y.switch_access.auto_scan.keyboard.speed_ms}}"
        ticks="[[autoScanSpeedRangeMs_]]"
        min="[[minScanSpeedMs_]]"
        max="[[maxScanSpeedMs_]]"
        label-aria="$i18n{switchAccessAutoScanKeyboardSpeedLabel}"
        label-min="[[minScanSpeedLabelSec_]]"
        label-max="[[maxScanSpeedLabelSec_]]"
        deep-link-focus-id$="[[Setting.kSwitchActionAutoScanKeyboard]]">
    </settings-slider>
  </div>
  <div class="settings-box continuation list-item">
    <div class="start sub-item settings-box-text" id="pointScanSpeed"
        aria-hidden="true">
      $i18n{switchAccessPointScanSpeedLabel}
    </div>
    <settings-slider id="pointScanSpeedSlider"
        pref="{{prefs.settings.a11y.switch_access.point_scan.speed_dips_per_second}}"
        ticks="[[pointScanSpeedRangeDipsPerSecond_]]"
        min="[[minPointScanSpeed_]]"
        max="[[maxPointScanSpeed_]]"
        label-aria="$i18n{switchAccessPointScanSpeedLabel}"
        label-min="[[minPointScanSpeed_]]"
        label-max="[[maxPointScanSpeed_]]">
    </settings-slider>
  </div>
</div>
<!--_html_template_end_-->`;
}
