import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-section-indent-width:60px}.sub-item{padding-inline-start:var(--cr-section-indent-width)}.settings-box{padding-inline-start:0}settings-toggle-button,cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}</style>
<settings-toggle-button
    icon="os-settings:text-to-speech"
    pref="{{prefs.settings.accessibility}}"
    label="$i18n{chromeVoxLabel}"
    sub-label="[[getChromeVoxDescription_(prefs.settings.accessibility.value)]]"
    deep-link-focus-id$="[[Setting.kChromeVox]]">
</settings-toggle-button>
<iron-collapse opened="[[prefs.settings.accessibility.value]]">
  <div class="sub-item">
    <cr-link-row id="chromevoxSubpageTrigger"
        class="settings-box" on-click="onChromeVoxSettingsClick_"
        label="$i18n{chromeVoxOptionsLabel}"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
  </div>
  <div class="sub-item">
    <cr-link-row id="chromeVoxTutorialButton"
        class="settings-box" on-click="onChromeVoxTutorialClick_"
        label="$i18n{chromeVoxTutorialLabel}"
        external>
    </cr-link-row>
  </div>
</iron-collapse>
<settings-toggle-button
    icon="os-settings:select-to-speak"
    pref="{{prefs.settings.a11y.select_to_speak}}"
    class="hr"
    label="$i18n{selectToSpeakTitle}"
    sub-label="[[getSelectToSpeakDescription_(
        prefs.settings.a11y.select_to_speak.value, hasKeyboard_)]]"
    deep-link-focus-id$="[[Setting.kSelectToSpeak]]">
</settings-toggle-button>
<iron-collapse opened="[[prefs.settings.a11y.select_to_speak.value]]">
  <div class="sub-item">
    <cr-link-row id="select-to-speak-subpage-trigger"
        class="settings-box" on-click="onSelectToSpeakSettingsClick_"
        label="$i18n{selectToSpeakLinkTitle}"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
  </div>
</iron-collapse>

<cr-link-row id="ttsSubpageButton" class="hr"
    label="$i18n{manageTtsSettings}" on-click="onManageTtsSettingsClick_"
    sub-label="$i18n{ttsSettingsLinkDescription}"
    role-description="$i18n{subpageArrowRoleDescription}" embedded>
</cr-link-row>
<!--_html_template_end_-->`;
}
