import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">h2{padding-inline-start:var(--cr-section-padding)}.settings-box{margin-inline-end:var(--cr-section-padding);margin-inline-start:var(--cr-section-indent-padding);padding-inline-end:0;padding-inline-start:0}#previewInput{width:70%;--cr-input-error-display:none}#previewInput cr-button{margin-inline-start:8px}</style>

<h2>$i18n{textToSpeechProperties}</h2>
<div class="settings-box first">
  <div class="start settings-box-text" id="rate" aria-hidden="true">
    $i18n{textToSpeechRate}
  </div>
  <settings-slider show-markers
      id="textToSpeechRate"
      pref="{{prefs.settings.tts.speech_rate}}"
      ticks="[[speechRateTicks_()]]"
      label-aria="$i18n{textToSpeechRate}"
      label-min="$i18n{textToSpeechRateMinimumLabel}"
      label-max="$i18n{textToSpeechRateMaximumLabel}"
      deep-link-focus-id$="[[Setting.kTextToSpeechRate]]">
  </settings-slider>
</div>
<div class="settings-box continuation">
  <div class="start settings-box-text" id="pitch" aria-hidden="true">
    $i18n{textToSpeechPitch}
  </div>
  <settings-slider show-markers
      pref="{{prefs.settings.tts.speech_pitch}}"
      ticks="[[speechPitchTicks_()]]"
      label-aria="$i18n{textToSpeechPitch}"
      label-min="$i18n{textToSpeechPitchMinimumLabel}"
      label-max="$i18n{textToSpeechPitchMaximumLabel}"
      deep-link-focus-id$="[[Setting.kTextToSpeechPitch]]">
  </settings-slider>
</div>
<div class="settings-box continuation">
  <div class="start settings-box-text" id="volume" aria-hidden="true">
    $i18n{textToSpeechVolume}
  </div>
  <settings-slider show-markers
      pref="{{prefs.settings.tts.speech_volume}}"
      ticks="[[speechVolumeTicks_()]]"
      label-aria="$i18n{textToSpeechVolume}"
      label-min="$i18n{textToSpeechVolumeMinimumLabel}"
      label-max="$i18n{textToSpeechVolumeMaximumLabel}"
      deep-link-focus-id$="[[Setting.kTextToSpeechVolume]]">
  </settings-slider>
</div>

<h2>$i18n{textToSpeechPreviewHeading}</h2>
<div class="settings-box first">
  <div id="textToSpeechPreviewVoice" class="start settings-box-text"
      aria-hidden="true">
    $i18n{textToSpeechPreviewVoice}
  </div>
  <select id="previewVoice" class="md-select"
      aria-labelledby="textToSpeechPreviewVoice"
      value="{{defaultPreviewVoice}}"
      disabled="[[!hasVoices]]"
      deep-link-focus-id$="[[Setting.kTextToSpeechVoice]]">
    <template is="dom-repeat" id="previewVoiceOptions"
        items="[[allVoices]]" as="voice">
      <!-- TODO: Use a combobox with a search field instead. -->
      <option value="[[voice.id]]">
        [[voice.displayLanguage]] - [[voice.displayName]]
      </option>
    </template>
  </select>
</div>
<div class="settings-box continuation">
  <div id="textToSpeechPreviewInput" class="start settings-box-text">
    $i18n{textToSpeechPreviewInputLabel}
  </div>
  <cr-input id="previewInput" aria-labelledby="textToSpeechPreviewInput"
      value="{{previewText_}}"
      disabled="[[isPreviewing_]]">
    <cr-button on-click="onPreviewTtsClick_"
        disabled$="[[!enablePreviewButton_(allVoices, isPreviewing_,
                     previewText_)]]"
        slot="suffix">
      $i18n{textToSpeechPreviewPlay}
    </cr-button>
  </cr-input>
</div>

<h2>$i18n{textToSpeechVoices}</h2>
<template is="dom-repeat" items="[[languagesToVoices]]" as="lang"
    filter="isPrimaryLanguage_"
    sort="alphabeticalSort_">
  <div class="settings-box first">
    <div class="start settings-box-text" aria-hidden="true">
      [[lang.language]]
    </div>
    <settings-dropdown-menu label="[[lang.language]]"
        pref="{{prefs.settings.tts.lang_to_voice_name}}"
        pref-key="[[lang.code]]"
        menu-options="[[menuOptionsForLang_(lang)]]"
        disabled="[[hasOneLanguage_(lang)]]">
    </settings-dropdown-menu>
  </div>
</template>
<cr-expand-button
    aria-label="$i18n{textToSpeechMoreLanguages}"
    class="settings-box continuation"
    expanded="{{languagesOpened}}"
    hidden="[[!hasVoices]]">
  $i18n{textToSpeechMoreLanguages}
</cr-expand-button>
<iron-collapse id="moreLanguages" opened="[[languagesOpened]]">
  <template is="dom-repeat" items="[[languagesToVoices]]"
      as="lang" sort="alphabeticalSort_" filter="isSecondaryLanguage_">
    <div class="settings-box continuation">
      <div class="start settings-box-text" aria-hidden="true">
        [[lang.language]]
      </div>
      <settings-dropdown-menu label="[[lang.language]]"
          pref="{{prefs.settings.tts.lang_to_voice_name}}"
          pref-key="[[lang.code]]"
          menu-options="[[menuOptionsForLang_(lang)]]"
          disabled="[[hasOneLanguage_(lang)]]"
          on-settings-control-change="onDefaultTtsVoicePicked_">
      </settings-dropdown-menu>
    </div>
  </template>
</iron-collapse>
<div class="settings-box first settings-box-text" hidden$="[[hasVoices]]">
  $i18n{textToSpeechNoVoicesMessage}
</div>

<h2>$i18n{textToSpeechEngines}</h2>
<template is="dom-repeat" items="[[extensions]]">
  <div class="settings-box continuation">
    <div id="extension_name_[[index]]" class="start settings-box-text">
      [[item.name]]
    </div>
    <cr-button id="extensionOptionsButton_[[index]]"
        class$="tast-[[item.name]]"
        on-click="onEngineSettingsClick_"
        aria-describedby$="extension_name_[[index]]"
        hidden$="[[!item.optionsPage]]"
        deep-link-focus-id$="[[Setting.kTextToSpeechEngines]]">
      $i18n{settings}
    </cr-button>
  </div>
</template>
<!--_html_template_end_-->`;
}
