import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#warningSelector>:not(.iron-selected){display:none}h3{font-size:inherit}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{aboutChangeChannel}</div>
  <div slot="body">
    <!-- TODO(dbeam): this can be policy-controlled. Show this in the UI.
         https://cloud.google.com/docs/chrome-enterprise/policies/?policy=ChromeOsReleaseChannel
    -->
    <cr-radio-group on-selected-changed="onChannelSelectionChanged_">
      <cr-radio-button name="[[browserChannelEnum_.STABLE]]">
        $i18n{aboutChannelDialogStable}
      </cr-radio-button>
      <cr-radio-button name="[[browserChannelEnum_.BETA]]">
        $i18n{aboutChannelDialogBeta}
      </cr-radio-button>
      <cr-radio-button name="[[browserChannelEnum_.DEV]]">
        $i18n{aboutChannelDialogDev}
      </cr-radio-button>
    </cr-radio-group>
    <iron-selector id="warningSelector">
      <div>
        <h3>$i18n{aboutDelayedWarningTitle}</h3>
        <div>[[substituteString_(
            '$i18nPolymer{aboutDelayedWarningMessage}',
            '$i18nPolymer{aboutOsProductTitle}')]]</div>
      </div>
      <div>
        <h2>$i18n{aboutPowerwashWarningTitle}</h2>
        <div>$i18n{aboutPowerwashWarningMessage}</div>
      </div>
      <div>
        <h2>$i18n{aboutUnstableWarningTitle}</h2>
        <div>[[substituteString_(
            '$i18nPolymer{aboutUnstableWarningMessage}',
            '$i18nPolymer{aboutOsProductTitle}')]]</div>
      </div>
    </iron-selector>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_"
        id="cancel">$i18n{cancel}</cr-button>
    <cr-button id="changeChannel" class="action-button"
        on-click="onChangeChannelClick_"
        hidden="[[!shouldShowButtons_.changeChannel]]">
      $i18n{aboutChangeChannel}
    </cr-button>
    <cr-button id="changeChannelAndPowerwash" class="action-button"
        on-click="onChangeChannelAndPowerwashClick_"
        hidden="[[!shouldShowButtons_.changeChannelAndPowerwash]]">
      $i18n{aboutChangeChannelAndPowerwash}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
