import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">cr-policy-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}#command-line{overflow-wrap:break-word;width:100%}#managedEolTooltipIcon{margin-inline-end:48px}#changeChannelButton{margin-inline-start:16px}</style>
<div class="settings-box two-line first">
  <div class="start">
    <div role="heading" aria-level="2">$i18n{aboutChannelLabel}</div>
    <div id="currentlyOnChannelText" aria-hidden="true" class="secondary">
      [[currentlyOnChannelText_]]
    </div>
  </div>
  <template is="dom-if" if="[[!canChangeChannel_]]">
    <cr-policy-indicator
        id="changeChannelPolicyIndicator"
        indicator-source-name="[[getChangeChannelIndicatorSourceName_(
            canChangeChannel_)]]"
        indicator-type="[[getChangeChannelIndicatorType_(
            canChangeChannel_)]]">
    </cr-policy-indicator>
  </template>
  <cr-button id="changeChannelButton"
      on-click="onChangeChannelClick_"
      aria-describedby="currentlyOnChannelText"
      disabled="[[!canChangeChannel_]]"
      deep-link-focus-id$="[[Setting.kChangeChromeChannel]]">
    $i18n{aboutChangeChannel}
  </cr-button>
  <template is="dom-if" if="[[showChannelSwitcherDialog_]]" restamp>
    <settings-channel-switcher-dialog
        on-close="onChannelSwitcherDialogClosed_">
    </settings-channel-switcher-dialog>
  </template>
</div>
<div id="endOfLifeSectionContainer"
    class="settings-box two-line single-column"
    hidden="[[shouldHideEolInfo_]]">
  <div role="heading" aria-level="2">$i18n{aboutEndOfLifeTitle}</div>
  <localized-link class="secondary"
      localized-string="[[eolMessageWithMonthAndYear]]">
  </localized-link>
</div>
<template is="dom-if" if="[[isManaged_]]">
  <div class="settings-box two-line">
    <div class="start" aria-hidden="true">
      <div role="heading">$i18n{aboutEndOfLifeTitle}</div>
      <div class="secondary">
        $i18n{aboutManagedEndOfLifeSubtitle}
      </div>
    </div>
    <cr-tooltip-icon
        id="managedEolTooltipIcon"
        icon-class="cr20:domain"
        tooltip-text="$i18n{aboutManagedEndOfLifeSubtitle}"
        icon-aria-label="$i18n{aboutManagedEndOfLifeSubtitle}"
        tooltip-position="bottom">
    </cr-tooltip-icon>
    <template is="dom-if" if="[[showManagedAutoUpdateToggle_]]" restamp>
      <cr-toggle
          id="managedAutoUpdateToggle"
          checked="[[isManagedAutoUpdateEnabled_]]"
          disabled>
      </cr-toggle>
    </template>
  </div>
</template>
<template is="dom-if" if="[[showConsumerAutoUpdateToggle_]]">
  <div class="settings-box two-line"
       on-click="onConsumerAutoUpdateToggledSettingsBox_">
    <div class="start" aria-hidden="true">
      <div role="heading">$i18n{aboutConsumerAutoUpdateToggleTitle}</div>
      <div class="secondary">
        $i18n{aboutConsumerAutoUpdateToggleDescription}
      </div>
    </div>
    <cr-toggle
        id="consumerAutoUpdateToggle"
        checked="{{prefs.settings.consumer_auto_update_toggle.value}}"
        disabled="[[!isConsumerAutoUpdateTogglingAllowed_]]"
        on-change="onConsumerAutoUpdateToggled_">
    </cr-toggle>
  </div>
  <template is="dom-if" if="[[showConsumerAutoUpdateToggleDialog_]]" restamp>
    <settings-consumer-auto-update-toggle-dialog
        on-close="onConsumerAutoUpdateToggleDialogClosed_">
    </settings-consumer-auto-update-toggle-dialog>
  </template>
</template>
<template is="dom-if" if="[[isHostnameSettingEnabled_]]">
  <div class="settings-box two-line">
    <div class="start">
      <div role="heading">$i18n{aboutDeviceName}</div>
      <div id="deviceName" aria-hidden="true" class="secondary">
        [[getDeviceNameText_(deviceNameMetadata_)]]
      </div>
    </div>
    <template is="dom-if" if="[[shouldShowPolicyIndicator_(
        deviceNameMetadata_)]]">
      <cr-policy-indicator
          id="editHostnamePolicyIndicator"
          indicator-type="[[getDeviceNameIndicatorType_(deviceNameMetadata_)]]">
      </cr-policy-indicator>
    </template>
    <div class="separator"></div>
    <cr-icon-button id="editHostnameButton"
        class="icon-edit"
        on-click="onEditHostnameClick_"
        aria-label="[[i18n('aboutDeviceNameEditBtnA11yLabel')]]"
        aria-description=
            "[[getDeviceNameEditButtonA11yDescription_(deviceNameMetadata_)]]"
        disabled="[[!canEditDeviceName_(deviceNameMetadata_)]]"
        deep-link-focus-id$="[[Setting.kChangeDeviceName]]">
    </cr-icon-button>
  </div>
  <template is="dom-if" if="[[showEditHostnameDialog_]]" restamp>
    <edit-hostname-dialog
        on-close="onEditHostnameDialogClosed_">
    </edit-hostname-dialog>
  </template>
</template>
<div id="buildDetailsLinkContainer" class="settings-box">
  <div class="start" id="aboutBuildDetailsTitle">
    $i18n{aboutBuildDetailsTitle}
  </div>
  <cr-icon-button id="copyBuildDetailsButton" class="icon-copy-content"
      aria-labelledby="copyBuildDetailsButtonToolTip"
      on-click="onCopyBuildDetailsToClipBoardClick_"
      disabled="[[!copyToClipBoardEnabled_(versionInfo_, channelInfo_)]]"
      deep-link-focus-id$="[[Setting.kCopyDetailedBuildInfo]]">
  </cr-icon-button>
  <paper-tooltip id="copyBuildDetailsButtonToolTip"
      for="copyBuildDetailsButton"
      position="bottom" fit-to-visible-bounds>
    $i18n{aboutBuildDetailsCopyTooltipLabel}
  </paper-tooltip>
  <div class="separator"></div>
  <cr-icon-button on-click="onVisitBuildDetailsPageClick_"
      aria-labelledby="aboutBuildDetailsTitle"
      class="icon-external">
  </cr-icon-button>
</div>
<!--_html_template_end_-->`;
}
