import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-dialog-width:335px;--cr-dialog-title-slot-padding-start:24px;--cr-dialog-title-slot-padding-end:24px;--cr-dialog-title-slot-padding-top:24px;--cr-dialog-title-slot-padding-bottom:0;--cr-dialog-body-padding-horizontal:24px;--cr-dialog-button-container-padding-horizontal:24px;--cr-dialog-button-container-padding-bottom:20px}:host([is-input-invalid_]) #inputInfo{color:var(--cros-text-color-alert)}#inputContainer{position:relative}#deviceNameInfo{margin-bottom:24px}#deviceName{margin:8px 0 24px 0}#inputInfo{background-color:var(--cros-bg-color-elevation-3);color:var(--cros-text-color-secondary);font-size:var(--cr-form-field-label-font-size);font-weight:400;height:30px;line-height:var(--cr-form-field-label-line-height);padding-top:8px;position:absolute;top:97px;width:100%}#inputCount{position:absolute;right:0;top:8px}:host-context([dir='rtl']) #inputCount{left:0;right:auto}#inputSubtitle{display:block;width:290px}</style>
<cr-dialog id="dialog" show-on-attach>
  <div slot="title">$i18n{aboutEditDeviceName}</div>
  <div slot="body">
    <div id="inputContainer">
      <div id="deviceNameInfo">$i18n{aboutDeviceNameInfo}</div>
      <!-- Set error-message so then it is read out by ChromeVox
          when cr-input is invalid. Since we already display the error
          message in #inputInfo, this is visually hidden by #inputInfo. -->
      <cr-input id="deviceName"
          value="{{deviceName_}}"
          spellcheck="false"
          invalid="[[isInputInvalid_]]"
          aria-label="[[i18n('aboutDeviceNameInputA11yLabel')]]"
          aria-description=
              "[[i18n('aboutDeviceNameConstraintsA11yDescription')]]"
          error-message="[[i18n('aboutDeviceNameConstraintsA11yDescription')]]"
          autofocus>
      </cr-input>
      <!-- Visual error message is different from the one read out by
          ChromeVox, hence the need for this #inputInfo div. -->
      <div id="inputInfo" aria-hidden="true">
        <span id="inputSubtitle">$i18n{aboutDeviceNameConstraints}</span>
        <span id="inputCount">[[inputCountString_]]</span>
      </div>
    </div>
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button"
        on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="done" class="action-button"
        on-click="onDoneClick_"
        disabled="[[isInputInvalid_]]"
        aria-label="[[i18n('aboutDeviceNameDoneBtnA11yLabel', deviceName_)]]">
      $i18n{done}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
