import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--chromeos-logo-width:40px}.info-section{margin-bottom:12px}.padded{padding-bottom:10px;padding-top:10px}#productRow{min-height:auto;padding-bottom:18px;padding-top:18px}#productRow>#productTitle{font:var(--cros-display-7-font);margin:0}#productRow>#productLogo{margin-inline-end:16px;width:var(--chromeos-logo-width)}.icon-container{margin-inline-end:10px;min-width:var(--chromeos-logo-width);text-align:center}#updateRowIcon{margin-inline-end:16px}iron-icon[icon='cr:check-circle']{fill:var(--cros-icon-color-prominent)}iron-icon[icon='cr:error-outline'],iron-icon[icon='cr:warning'],iron-icon[icon='os-settings:end-of-life']{fill:var(--cros-icon-color-alert)}iron-icon[icon='os-settings:about-update-complete']{fill:var(--cros-sys-positive)}iron-icon[icon='os-settings:about-update-warning']{fill:var(--cros-sys-warning)}iron-icon[icon='os-settings:about-update-error']{fill:var(--cros-sys-error)}iron-icon[icon='cr20:domain']{fill:var(--cros-sys-primary)}#firmwareUpdateBadge{--iron-icon-fill-color:var(--cros-icon-color-secondary)}.settings-box .start{overflow-x:auto}cr-button{white-space:nowrap}#regulatoryInfo img{width:330px}@media (prefers-color-scheme:dark){#regulatoryInfo img{filter:invert(1)}}.separator-firmware-updates-badge{margin-inline-end:-4px;margin-inline-start:12px}#deferredUpdateButtons{min-height:unset;padding-bottom:10px}eol-offer-section{margin:6px 3px 16px 3px}</style>
<iron-media-query query="(prefers-color-scheme: dark)"
    query-matches="{{isDarkModeActive_}}">
</iron-media-query>

  <os-settings-animated-pages id="pages" section="[[section_]]">
    <div route-path="default">
      <settings-card header-text="$i18n{aboutOsPageTitle}">
        <div id="productRow" class="settings-box first">
          <img id="productLogo" on-click="onProductLogoClick_"
              srcset="chrome://theme/current-channel-logo@1x 1x,
                      chrome://theme/current-channel-logo@2x 2x"
              alt="$i18n{aboutProductLogoAlt}"
              role="presentation">
          <h1 id="productTitle">$i18n{aboutOsProductTitle}</h1>
        </div>
        <div class="settings-box two-line">
          <!-- Set the icon from the iconset (when it's obsolete/EOL and
            when update is done) or set the src (when it's updating). -->
          <iron-icon id="updateRowIcon"
              icon$="[[getUpdateStatusIcon_(
                  hasEndOfLife_, currentUpdateStatusEvent_,
                  showExtendedUpdatesOption_)]]"
              src="[[getThrobberSrcIfUpdating_(
                  isDarkModeActive_,
                  hasEndOfLife_,
                  currentUpdateStatusEvent_,
                  showExtendedUpdatesOption_)]]">
          </iron-icon>
          <div class="start padded">
            <div id="updateStatusMessage" hidden="[[!showUpdateStatus_]]">
              <div id="updateStatusMessageInner" tabindex="-1"
                  inner-h-t-m-l="[[getUpdateStatusMessage_(
                  currentUpdateStatusEvent_, targetChannel_)]]"></div>
              <a hidden$="[[!shouldShowLearnMoreLink_(
                  currentUpdateStatusEvent_)]]" target="_blank"
                  href="https://support.google.com/chrome?p=update_error">
                $i18n{learnMore}
              </a>
            </div>
            <template is="dom-if" if="[[showEolIncentive_]]">
              <eol-offer-section id="endOfLifeOfferContainer"
                  should-show-offer-text="[[shouldShowOfferText_]]">
              </eol-offer-section>
            </template>
            <localized-link
                id="endOfLifeMessage" hidden="[[!hasEndOfLife_]]"
                localized-string="$i18n{endOfLifeMessage}">
            </localized-link>
            <div hidden="[[!showExtendedUpdatesOption_]]">
              <div id="extendedUpdatesMainMessage">
                $i18n{extendedUpdatesMainMessage}
              </div>
              <localized-link
                  id="extendedUpdatesSecondaryMessage"
                  class="secondary"
                  localized-string="$i18n{extendedUpdatesSecondaryMessage}">
              </localized-link>
            </div>
            <div class="secondary" hidden="[[!hasDeferredUpdate_]]">
              $i18n{aboutDeferredUpdate}
            </div>
            <div class="secondary">$i18n{aboutBrowserVersion}</div>
          </div>
          <div class="separator" hidden="[[!showButtonContainer_]]"></div>
          <span id="buttonContainer" hidden="[[!showButtonContainer_]]">
            <cr-button id="relaunchButton" hidden$="[[!showRelaunch_]]"
                      on-click="onRelaunchClick_">
                [[getRelaunchButtonText_(
                                currentUpdateStatusEvent_)]]
            </cr-button>
            <cr-button id="checkForUpdatesButton" hidden="[[!showCheckUpdates_]]"
                on-click="onCheckUpdatesClick_"
                deep-link-focus-id$="[[Setting.kCheckForOsUpdate]]">
              $i18n{aboutCheckForUpdates}
            </cr-button>
            <cr-button id="extendedUpdatesButton"
                hidden="[[!showExtendedUpdatesOption_]]"
                on-click="onExtendedUpdatesButtonClick_">
              $i18n{aboutExtendedUpdatesButton}
            </cr-button>
          </span>
        </div>
        <div id="deferredUpdateButtons" class="settings-box first"
            hidden="[[!hasDeferredUpdate_]]">
          <div class="icon-container"></div>
          <cr-button id="applyDeferredUpdateAdvanced"
              on-click="onApplyDeferredUpdateAdvancedClick_">
            $i18n{aboutRelaunch}
          </cr-button>
          <cr-button id="applyAndSetAutoUpdate"
              on-click="onApplyAndSetAutoUpdateClick_">
            $i18n{aboutRelaunchAndAutoUpdate}
          </cr-button>
        </div>
        <cr-link-row
            id="aboutTPMFirmwareUpdate"
            class="hr"
            start-icon="os-settings:startup"
            hidden$="[[!showTPMFirmwareUpdateLineItem_]]"
            label="$i18n{aboutTPMFirmwareUpdateTitle}"
            on-click="onTpmFirmwareUpdateClick_">
          <div slot="sub-label">
            $i18n{aboutTPMFirmwareUpdateDescription}
            <a href="$i18n{aboutTPMFirmwareUpdateLearnMoreURL}"
                target="_blank" on-click="onLearnMoreClick_">
              $i18n{learnMore}
            </a>
          </div>
        </cr-link-row>
        <template is="dom-if" if="[[hasInternetConnection_]]">
          <cr-link-row class="hr" id="releaseNotesOnline"
              start-icon="os-settings:about-release-notes"
              on-click="onReleaseNotesClick_"
              label="$i18n{aboutShowReleaseNotes}"
              sub-label="$i18n{aboutShowReleaseNotesDescription}"
              external
              deep-link-focus-id$="[[Setting.kSeeWhatsNew]]">
          </cr-link-row>
        </template>
        <template is="dom-if" if="[[!hasInternetConnection_]]">
          <cr-link-row class="hr" id="releaseNotesOffline"
              start-icon="os-settings:about-release-notes"
              on-click="onReleaseNotesClick_"
              label="$i18n{aboutShowReleaseNotes}"
              title="$i18n{aboutReleaseNotesOffline}"
              external
              deep-link-focus-id$="[[Setting.kSeeWhatsNew]]">
          </cr-link-row>
        </template>
        <cr-link-row class="hr" id="help"
            start-icon="os-settings:about-help"
            on-click="onHelpClick_"
            label="$i18n{aboutGetHelpUsingChromeOs}"
            sub-label="$i18n{aboutGetHelpDescription}"
            external
            deep-link-focus-id$="[[Setting.kGetHelpWithChromeOs]]">
        </cr-link-row>
  
        <cr-link-row class="hr" id="diagnostics"
            start-icon="os-settings:about-diagnostics"
            on-click="onDiagnosticsClick_"
            label="$i18n{aboutDiagnostics}"
            sub-label="$i18n{aboutDiagnosticseDescription}"
            external
            deep-link-focus-id$="[[Setting.kDiagnostics]]">
        </cr-link-row>
        <template is="dom-if" if="[[canChangeFirmware_]]">
        <cr-link-row class="hr" id="firmwareUpdates"
            start-icon="os-settings:about-firmware-updates"
            on-click="onFirmwareUpdatesClick_"
            label="$i18n{aboutFirmwareUpdates}"
            sub-label="[[getFirmwareSublabel_(firmwareUpdateCount_)]]"
            external
            using-slotted-label
            deep-link-focus-id$="[[Setting.kFirmwareUpdates]]">
          <iron-icon id="firmwareUpdateBadge"
              icon$="[[getFirmwareUpdatesIcon_(firmwareUpdateCount_)]]"
              hidden$="[[!shouldShowFirmwareUpdatesBadge_(
                firmwareUpdateCount_)]]">
          </iron-icon>
          <div id="firmwareUpdateBadgeSeparator"
              class="separator separator-firmware-updates-badge"
              hidden$="[[!shouldShowFirmwareUpdatesBadge_(
                firmwareUpdateCount_)]]">
          </div>
        </cr-link-row>
        </template>
        <template is="dom-if" if="[[!canChangeFirmware_]]">
        <cr-link-row class="hr" id="firmwareUpdates"
            start-icon="os-settings:about-firmware-updates"
            label="$i18n{aboutFirmwareUpdates}"
            sub-label="[[getFirmwareSublabel_(firmwareUpdateCount_)]]"
            external
            using-slotted-label
            disabled=true
            deep-link-focus-id$="[[Setting.kFirmwareUpdates]]">
          <iron-icon id="firmwareUpdateBadge"
              icon$="[[getFirmwareUpdatesIcon_(firmwareUpdateCount_)]]"
              hidden$="[[!shouldShowFirmwareUpdatesBadge_(
                firmwareUpdateCount_)]]">
          </iron-icon>
          <div id="firmwareUpdateBadgeSeparator"
              class="separator separator-firmware-updates-badge"
              hidden$="[[!shouldShowFirmwareUpdatesBadge_(
                firmwareUpdateCount_)]]">
          </div>
          <cr-policy-indicator
            id="changeChannelPolicyIndicator"
            indicator-type="[[getFirmwareDisabledIndicatorType_()]]">
           </cr-policy-indicator>
        </cr-link-row>
        </template>
        <cr-link-row class="hr" id="detailedBuildInfoTrigger"
            start-icon="os-settings:about-additional-details"
            on-click="onDetailedBuildInfoClick_"
            label="$i18n{aboutDetailedBuildInfo}"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
        <cr-link-row class="hr" on-click="onManagementPageClick_"
            start-icon="cr:domain" label="$i18n{managementPage}"
            hidden$="[[!isManaged_]]"
            external>
        </cr-link-row>
      </settings-card>

      <crostini-settings-card prefs="{{prefs}}"></crostini-settings-card>

      <settings-card id="copyrightCard">
        <div class="settings-box padded block first">
          <div class="info-section">
            <div class="secondary">$i18n{aboutOsProductTitle}</div>
            <div class="secondary">$i18n{aboutProductCopyright}</div>
          </div>

          <div class="info-section">
            <div class="secondary">
              <span>$i18nRaw{aboutProductLicenseChromium}</span>
              <localized-link
                localized-string="$i18nRaw{aboutProductLicenseOther}"
                on-link-clicked="onProductLicenseOtherClicked_">
              </localized-link>
            </div>
            <div class="secondary" inner-h-t-m-l="[[getAboutProductOsLicense_(
                    showCrostiniLicense_)]]">
            </div>
          </div>
          
        </div>
        <div id="regulatoryInfo" class="settings-box padded block"
            hidden$="[[!shouldShowRegulatoryOrSafetyInfo_(regulatoryInfo_)]]">
          
          <img src="[[regulatoryInfo_.url]]" alt="[[regulatoryInfo_.text]]"
            hidden$="[[!shouldShowRegulatoryInfo_(regulatoryInfo_)]]">
        </div>
      </settings-card>
    </div>

    <template is="dom-if" route-path="/help/details">
      <os-settings-subpage page-title="$i18n{aboutDetailedBuildInfo}">
        <settings-detailed-build-info-subpage
            eol-message-with-month-and-year=
                "[[eolMessageWithMonthAndYear_]]"
            prefs="{{prefs}}">
        </settings-detailed-build-info-subpage>
      </os-settings-subpage>
    </template>

    <!-- Crostini settings subpages -->
    <template is="dom-if" route-path="/crostini/details">
      <os-settings-subpage page-title="$i18n{crostiniPageLabel}">
        <settings-crostini-subpage prefs="{{prefs}}">
        </settings-crostini-subpage>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/crostini/androidAdb">
      <os-settings-subpage page-title="$i18n{crostiniArcAdbTitle}">
        <settings-crostini-arc-adb prefs="{{prefs}}">
        </settings-crostini-arc-adb>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/crostini/portForwarding">
      <os-settings-subpage page-title="$i18n{crostiniPortForwarding}">
        <settings-crostini-port-forwarding prefs="{{prefs}}">
        </settings-crostini-port-forwarding>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/crostini/exportImport">
      <os-settings-subpage page-title="$i18n{crostiniExportImportTitle}">
        <settings-crostini-export-import prefs="{{prefs}}">
        </settings-crostini-export-import>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/crostini/sharedPaths">
      <os-settings-subpage page-title="$i18n{guestOsSharedPaths}">
        <settings-guest-os-shared-paths
            guest-os-type="crostini" prefs="{{prefs}}">
        </settings-guest-os-shared-paths>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/crostini/sharedUsbDevices">
      <os-settings-subpage page-title="$i18n{guestOsSharedUsbDevicesLabel}">
        <settings-crostini-shared-usb-devices prefs="{{prefs}}">
        </settings-crostini-shared-usb-devices>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/crostini/extraContainers">
      <os-settings-subpage page-title="$i18n{crostiniExtraContainersLabel}">
        <settings-crostini-extra-containers guest-os-type="crostini">
        </settings-crostini-extra-containers>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/bruschetta/details">
      <os-settings-subpage page-title="$i18n{bruschettaPageLabel}">
        <settings-bruschetta-subpage prefs="{{prefs}}">
        </settings-bruschetta-subpage>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/bruschetta/sharedUsbDevices">
      <os-settings-subpage page-title="$i18n{guestOsSharedUsbDevicesLabel}">
        <settings-guest-os-shared-usb-devices guest-os-type="bruschetta"
          prefs="{{prefs}}">
        </settings-guest-os-shared-usb-devices>
      </os-settings-subpage>
    </template>

    <template is="dom-if" route-path="/bruschetta/sharedPaths">
      <os-settings-subpage page-title="$i18n{guestOsSharedPaths}">
        <settings-guest-os-shared-paths
            guest-os-type="bruschetta" prefs="{{prefs}}">
        </settings-guest-os-shared-paths>
      </os-settings-subpage>
    </template>

    <!-- Internal subpages -->
    <template is="dom-if" route-path="/_internal/_storybook">
      <os-settings-subpage page-title="Storybook"
          hide-back-button>
        <settings-storybook-subpage></settings-storybook-subpage>
      </os-settings-subpage>
    </template>
  </os-settings-animated-pages>

<template is="dom-if" if="[[showUpdateWarningDialog_]]" restamp>
  <settings-update-warning-dialog update-info="[[updateInfo_]]"
      on-close="onUpdateWarningDialogClose_">
  </settings-update-warning-dialog>
</template>
<template is="dom-if" if="[[showTPMFirmwareUpdateDialog_]]"
    restamp>
  <os-settings-powerwash-dialog request-tpm-firmware-update
      on-close="onPowerwashDialogClose_">
  </os-settings-powerwash-dialog>
</template>
<!--_html_template_end_-->`;
}
