import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>

<cr-link-row id="openGooglePlayRow" label="$i18n{androidOpenGooglePlay}"
    on-click="onOpenGooglePlayClick_"
    external>
</cr-link-row>

<template is="dom-if" if="[[androidAppsInfo.settingsAppAvailable]]" restamp>
  <cr-link-row id="manageApps" class="hr" label="$i18n{androidAppsManageApps}"
      on-click="onManageAndroidAppsClick_"
      external
      deep-link-focus-id$="[[Setting.kManageAndroidPreferences]]">
  </cr-link-row>
</template>

<template is="dom-if" if="[[isArcVmManageUsbAvailable]]">
  <cr-link-row
      class="hr"
      label="$i18n{guestOsSharedUsbDevicesLabel}"
      sub-label="$i18n{guestOsSharedUsbDevicesDescription}"
      id="manageArcvmShareUsbDevices"
      on-click="onSharedUsbDevicesClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>

<!-- Use 'restamp' so tests can check if the row exists. -->
<template is="dom-if" if="[[allowRemove_(prefs.arc.enabled.*)]]" restamp>
  <div id="remove" class="settings-box">
    <div id="androidRemoveLabel" class="start">
      $i18n{androidAppsRemove}
    </div>
    <cr-button on-click="onRemoveClick_"
        aria-labelledby="androidRemoveLabel"
        deep-link-focus-id$="[[Setting.kRemovePlayStore]]">
      $i18n{androidAppsRemoveButton}
    </cr-button>
  </div>
</template>

<!-- Confirm disable android apps dialog -->
<cr-dialog id="confirmDisableDialog" close-text="$i18n{close}"
    on-cancel="onConfirmDisableDialogCancel_"
    on-close="onConfirmDisableDialogClose_">
  <div slot="title">$i18n{androidAppsDisableDialogTitle}</div>
  <div slot="body" inner-h-t-m-l="[[dialogBody_]]"></div>
  <div slot="button-container">
    <cr-button class="cancel-button"
        on-click="onConfirmDisableDialogCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button"
        on-click="onConfirmDisableDialogConfirm_">
      $i18n{androidAppsDisableDialogRemove}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
