import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="app-management-cros-shared-style settings-shared">#infoIcon{--paper-tooltip-min-width:max-content;margin-inline-start:3px}#launchIcon{--cr-icon-image:url(chrome://resources/images/open_in_new.svg);--cr-icon-button-fill-color:var(--cr-link-color);border-radius:0;height:var(--help-icon-size);margin-inline-start:3px;width:var(--help-icon-size)}#tooltipText{font-size:10px;line-height:12px;white-space:nowrap}#typeAndSource{display:flex}</style>
<div class="permission-section-header">
  <localized-link id="heading" class="header-text"
    localized-string="$i18n{appManagementAppDetailsTitle}">
  </localized-link>
</div>
<div class="indented-app-details" id="typeAndSource">
  <localized-link
    id="typeAndSourceText"
    on-link-clicked="onStoreLinkClicked_"
    localized-string="[[getTypeAndSourceString_(app)]]">
    [[getTypeAndSourceString_(app)]] <!-- Do not delete for testing purposes -->
  </localized-link>
  <template is="dom-if" if="[[shouldShowLaunchIcon_(app)]]">
    <!-- The following button is solely for visual representation and does not
      need to be shown to a11y. -->
    <cr-icon-button
      id="launchIcon"
      on-click="onStoreLinkClicked_"
      aria-hidden="true"
      tabindex="-1">
    </cr-icon-button>
  </template>
  <template is="dom-if" if="[[shouldShowInfoIcon_(app)]]" restamp>
    <div id="infoIcon">
      <cr-tooltip-icon
        tooltip-text="[[getTooltipText_(app)]]"
        icon-class="cr:info-outline"
        icon-aria-label="[[getTooltipA11yText_(app)]]">
      </cr-tooltip-icon>
    </div>
  </template>
</div>
<template is="dom-if" if="[[shouldShowVersion_(app)]]" restamp>
  <div class="indented-app-details" id="version">
    [[i18n('appManagementAppDetailsVersion', app.version)]]
  </div>
</template>
<template is="dom-if" if="[[shouldShowStorage_(app)]]" restamp>
  <div class="indented-app-details" id="storageTitle">
    $i18n{appManagementAppDetailsStorageTitle}
    <template is="dom-if" if="[[shouldShowAppSize_(app)]]" restamp>
      <div class="indented-app-details" id="appSize">
        [[i18n('appManagementAppDetailsAppSize', app.appSize)]]
      </div>
    </template>
    <template is="dom-if" if="[[shouldShowDataSize_(app)]]" restamp>
      <div class="indented-app-details" id="dataSize">
        [[i18n('appManagementAppDetailsDataSize', app.dataSize)]]
      </div>
    </template>
  </div>
</template>
<!--_html_template_end_-->`;
}
