import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="app-management-cros-shared-style">.permission-text-row{border-top:none}iron-icon{--iron-icon-fill-color:var(--secondary-text-color);padding-inline-end:var(--row-item-icon-padding)}localized-link{color:var(--secondary-text-color);white-space:pre-line}</style>

<div class="permission-list">
  <app-management-pin-to-shelf-item
      id="pinToShelfSetting"
      class="permission-card-row separated-row"
      app="[[app_]]">
  </app-management-pin-to-shelf-item>
  <div class="permission-card-row">
    <div class="permission-section-header">
      <div class="header-text">$i18n{appManagementPermissionsLabel}</div>
    </div>
    <div class="permission-list indented-permission-block">
      <div class=permission-text-row aria-hidden="true">
        <div class="horizontal-align">
          <iron-icon id="icon" icon="cr:help-outline"></iron-icon>
          <template is="dom-if" if="[[isMainApp_(app_.*)]]" restamp>
            <localized-link
                id="mainLink"
                localized-string="$i18n{borealisMainPermissionText}">
            </localized-link>
          </template>
          <template is="dom-if" if="[[!isMainApp_(app_.*)]]" restamp>
            <localized-link
                id="borealisLink"
                localized-string="$i18n{borealisAppPermissionText}"
                on-link-clicked="onBorealisLinkClicked_">
            </localized-link>
          </template>
        </div>
      </div>
      <app-management-permission-item
          id="microphonePermission"
          app="[[app_]]"
          class="subpermission-row" icon="app-management:microphone"
          permission-label="$i18n{appManagementMicrophonePermissionLabel}"
          permission-type="kMicrophone"
          prefs="{{prefs}}">
      </app-management-permission-item>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}
