import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="app-management-cros-shared-style">.permission-text-row:first-of-type{border-top:none}#noPermissions{border-top:none}</style>
<div>
  <div class="permission-list">
    <app-management-pin-to-shelf-item
        id="pinToShelfSetting"
        class="permission-card-row separated-row header-text"
        app="[[app_]]">
    </app-management-pin-to-shelf-item>

    <div id="permissionsCard" class="permission-card-row">
      <div class="permission-section-header">
        <div class="header-text">$i18n{appManagementPermissionsLabel}</div>
      </div>
      <div class="indented-permission-block">
        <template is="dom-repeat"
            items="[[getPermissionMessages_(messages_)]]" as="message">
          <div class="permission-text-row">
            [[message]]
          </div>
          <div id="secondLevelPermissions" class="indented-permission-block">
            <template is="dom-repeat"
                items="[[getPermissionSubmessagesByMessage_(index, messages_)]]"
                as="submessage">
              <div class="permission-text-row">
                [[submessage]]
              </div>
            </template>
          </div>
        </template>
        <template is="dom-if" if="[[!hasPermissions_(messages_)]]">
          <div id="noPermissions" class="permission-text-row">
            $i18n{appManagementNoPermissions}
          </div>
        </template>
      </div>
    </div>

    <app-management-more-permissions-item id="moreSettings"
        class="permission-card-row separated-row" app="[[app_]]"
        hidden$="[[app_.hideMoreSettings]]"
        more-permissions-label="$i18n{appManagementMorePermissionsLabelChromeApp}">
    </app-management-more-permissions-item>
    <app-management-app-details-item
        id="appDetails"
        class="permission-card-row"
        app="[[app_]]">
    </app-management-app-details-item>
</div>
<!--_html_template_end_-->`;
}
