import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="app-management-cros-shared-style">:host{align-items:center;display:flex;justify-content:space-between}:host(:not([disabled_])){cursor:pointer}:host(:not([available_])){display:none}</style>
<!-- permission-item does not include any icon-set, so containing
  elements should import the icon-set needed for the specified |icon|. -->
<template is="dom-if" if="[[available_]]">
  <app-management-toggle-row
      id="toggle-row"
      icon="[[icon]]"
      label="[[permissionLabel]]"
      managed="[[isManaged_(app, permissionType)]]"
      disabled="[[isDisabled_(app, permissionType)]]"
      value="[[getValue_(app, permissionType)]]"
      aria-description=
        "$i18n{appManagementPermissionItemClickTogglePermission}">
    <template is="dom-if" if="[[showPermissionDescriptionString_]]">
      <localized-link
          id="permissionDescription"
          slot="description"
          localized-string="[[getPermissionDescriptionString_(app,
            permissionType, prefs.ash.user.camera_allowed.value,
            prefs.ash.user.microphone_allowed.value,
            prefs.ash.user.geolocation_access_level.value,
            sensorAvailable_, microphoneHardwareToggleActive,
            microphoneMutedBySecurityCurtain, cameraSwitchForceDisabled)]]"
          on-link-clicked="launchAllowSensorAccessDialog_">
      </localized-link>
    </template>
  </app-management-toggle-row>
  <template is="dom-if" if="[[showAllowSensorAccessDialog_]]" restamp>
    <settings-privacy-hub-allow-sensor-access-dialog
        id="dialog"
        prefs="{{prefs}}"
        permission-type="[[permissionType]]"
        on-close="onAllowSensorAccessDialogClose_">
    </settings-privacy-hub-allow-sensor-access-dialog>
  </template>
</template>
<!--_html_template_end_-->`;
}
