import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="app-management-cros-shared-style"></style>

<div class="permission-list">
  <app-management-pin-to-shelf-item id="pinToShelfSetting"
    class="permission-card-row separated-row" app="[[app_]]">
  </app-management-pin-to-shelf-item>
  <div class="permission-card-row">
    <div class="permission-section-header">
      <div class="header-text">$i18n{appManagementPermissionsLabel}</div>
    </div>
    <div class="permission-list indented-permission-block">
      <app-management-permission-item id="cameraPermission"
        app="[[app_]]"
        class="subpermission-row" icon="app-management:camera"
        sync-permission-manually
        permission-label="$i18n{appManagementCameraPermissionLabel}"
        permission-type="kCamera" on-change="onPermissionChanged_">
      </app-management-permission-item>
      <app-management-permission-item id="microphonePermission"
        app="[[app_]]"
        class="subpermission-row" icon="app-management:microphone"
        sync-permission-manually
        permission-label="$i18n{appManagementMicrophonePermissionLabel}"
        permission-type="kMicrophone" on-change="onPermissionChanged_">
      </app-management-permission-item>
      <app-management-permission-item class="subpermission-row" icon="cr:print"
        app="[[app_]]"
        permission-label="$i18n{appManagementPrintingPermissionLabel}"
        permission-type="kPrinting">
      </app-management-permission-item>
    </div>
  </div>

  <div class="permission-card-row separated-row header-text clickable"
    on-click="onSharedPathsClick_">
    <div id="sharedPathsLabel" class="header-text" aria-hidden="true">
      $i18n{guestOsSharedPaths}
    </div>
    <div class="permission-row-controls">
      <cr-icon-button class="subpage-arrow app-management-item-arrow"
        role="link" tabindex="0" aria-labelledby="sharedPathsLabel">
      </cr-icon-button>
    </div>
  </div>
  <div class="permission-card-row separated-row header-text clickable"
    on-click="onSharedUsbDevicesClick_">
    <div id="sharedUsbDevicesLabel" class="header-text" aria-hidden="true">
      $i18n{guestOsSharedUsbDevicesLabel}
    </div>
    <div class="permission-row-controls">
      <cr-icon-button class="subpage-arrow app-management-item-arrow"
        role="link" tabindex="0" aria-labelledby="sharedUsbDevicesLabel">
      </cr-icon-button>
    </div>
  </div>
</div>

<template is="dom-if" if="[[showDialog_]]" restamp>
  <cr-dialog close-text="$i18n{close}" show-on-attach on-cancel="onCancel_">
    <div slot="body">[[dialogText_]]</div>
    <div slot="button-container">
      <cr-button class="cancel-button" on-click="onCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button class="action-button" on-click="onRelaunchClick_">
        $i18n{pluginVmPermissionDialogRelaunchButton}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}
