import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="app-management-cros-shared-style">:host{align-items:center;display:flex;justify-content:space-between}:host(:not([available_])){display:none}#icon{padding-inline-end:var(--row-item-icon-padding)}</style>

<template is="dom-if" if="[[available_]]">
  <div class="horizontal-align">
    <iron-icon id="icon" icon="[[icon]]"></iron-icon>
    <div class="vertical-align">
      <!--
        permission-name and permission-state classes are used by tast tests to
        find permission elements.
      -->
      <div id="label" class="permission-name">[[permissionLabel]]</div>
      <localized-link
          id="permissionDescription"
          class="permission-state secondary-text"
          localized-string="[[getPermissionDescriptionString_(app,
            permissionType, prefs.ash.user.camera_allowed.value,
            prefs.ash.user.microphone_allowed.value,
            prefs.ash.user.geolocation_access_level.value,
            sensorAvailable_, microphoneHardwareToggleActive,
            microphoneMutedBySecurityCurtain, cameraSwitchForceDisabled)]]"
          on-link-clicked="launchAllowSensorAccessDialog_">
      </localized-link>
    </div>
  </div>
  <template is="dom-if" if="[[isManaged_(app, permissionType)]]">
    <cr-policy-indicator indicator-type="devicePolicy">
    </cr-policy-indicator>
  </template>
  <template is="dom-if" if="[[showAllowSensorAccessDialog_]]" restamp>
    <settings-privacy-hub-allow-sensor-access-dialog
        id="dialog"
        prefs="{{prefs}}"
        permission-type="[[permissionType]]"
        on-close="onAllowSensorAccessDialogClose_">
    </settings-privacy-hub-allow-sensor-access-dialog>
  </template>
</template>
<!--_html_template_end_-->`;
}
