import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="app-management-cros-shared-style">#disabledExplanationText{align-items:center;display:flex;flex-direction:row;height:var(--info-text-row-height)}#supportedLinksOption{height:48px}.info-icon{height:var(--help-icon-size);width:var(--help-icon-size)}#overlapWarning{color:var(--secondary-text-color);margin-block-start:-12px;margin-inline-start:36px}.list-frame{display:block;padding-block-end:0;padding-block-start:0;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}cr-radio-group{width:100%}iron-icon{flex-shrink:0}cr-radio-button{min-height:var(--cr-section-min-height)}</style>
<div class="permission-section-header">
  <localized-link id="heading" class="header-text"
      on-link-clicked="launchDialog_"
      localized-string="[[i18nAdvanced('appManagementIntentSettingsTitle')]]">
  </localized-link>
</div>
<template is="dom-if" if="[[disabled_]]">
  <span class="info-text-row" id="disabledExplanationText">
    <iron-icon id="infoIcon" icon="app-management:info"></iron-icon>
    <localized-link id="infoString"
      localized-string="[[getDisabledExplanation_(app)]]">
    </localized-link>
  </span>
</template>
<div class="list-frame">
  <cr-radio-group id="radioGroup"
      selected="[[getCurrentPreferredApp_(app)]]"
      on-selected-changed="onSupportedLinkPrefChanged_"
      disabled="[[disabled_]]">
    <cr-radio-button
        id="preferredRadioButton"
        name="preferred"
        label="[[getPreferredLabel_(app)]]">
    </cr-radio-button>
    <cr-radio-button
        id="browserRadioButton"
        name="browser"
        label="[[i18n('appManagementIntentSharingOpenBrowserLabel')]]">
    </cr-radio-button>
    <template is="dom-if" if="[[showOverlappingAppsWarning_]]">
      <div id="overlapWarning">
        [[overlappingAppsWarning_]]
      </div>
    </template>
  </cr-radio-group>
</div>
<template is="dom-if" if="[[showSupportedLinksDialog_]]" restamp>
  <app-management-supported-links-dialog id="dialog" app="[[app]]"
      on-close="onDialogClose_">
  </app-management-supported-links-dialog>
</template>
<template is="dom-if" if="[[showOverlappingAppsDialog_]]" restamp>
  <app-management-supported-links-overlapping-apps-dialog
      id="overlapDialog"
      app="[[app]]"
      apps="[[apps]]"
      on-close="onOverlappingDialogClosed_"
      overlapping-app-ids="[[overlappingAppIds_]]">
  </app-management-supported-links-overlapping-apps-dialog>
</template>
<!--_html_template_end_-->`;
}
