import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="app-management-cros-shared-style">:host{align-items:center;display:flex;flex:1;justify-content:space-between}#icon{padding-inline-end:var(--row-item-icon-padding)}#policyIndicator{padding-inline-end:var(--app-management-controlled-by-spacing)}</style>

<div id="left-content" class="horizontal-align">
  <template is="dom-if" if="[[icon]]">
    <iron-icon id="icon" icon="[[icon]]"></iron-icon>
  </template>
  <div class="vertical-align">
    <div id="label">[[label]]</div>
    <div id="description" class="secondary-text">
      [[description]]
      <slot name="description"></slot>
    </div>
  </div>
</div>
<div id="right-content" class="horizontal-align">
  <template is="dom-if" if="[[managed]]">
    <cr-policy-indicator id="policyIndicator"
        indicator-type="devicePolicy">
    </cr-policy-indicator>
  </template>
  <cr-toggle id="toggle"
      checked="[[value]]"
      disabled="[[isDisabled_(disabled, managed)]]"
      role="button"
      tabindex="0"
      aria-pressed="[[value]]"
      aria-label="[[label]]">
  </cr-toggle>
</div>
<!--_html_template_end_-->`;
}
