import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#setupPinKeyboardDiv{justify-content:center}#pinSetupDialogSubtitle{min-height:48px;padding-bottom:16px}cr-dialog::part(dialog){max-width:100%}</style>
<cr-dialog id="dialog" on-close="close"
    close-text="$i18n{close}">
  <div slot="title">[[getTitle_(isConfirmStep_)]]</div>
  <div slot="body">
    <div id="pinSetupDialogSubtitle">[[getSubtitle_(isConfirmStep_)]]</div>
    <div id="setupPinKeyboardDiv" class="settings-box continuation">
      <app-setup-pin-keyboard id="setupPinKeyboard"
        is-confirm-step="{{isConfirmStep_}}"
        prefs="{{prefs}}"
        enable-submit="{{enableSubmit_}}"
        aria-label="[[getTitle_(isConfirmStep_)]]">
      </app-setup-pin-keyboard>
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onPinSubmit_"
      disabled$="[[!enableSubmit_]]">
      <span>[[getContinueMessage_(isConfirmStep_)]]</span>
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
