// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '../../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './block_app_item.html.js';
import { getAppParentalControlsProvider } from './mojo_interface_provider.js';
/** An element that represents the app that can be blocked with the toggle. */
export class BlockAppItemElement extends PolymerElement {
    static get is() {
        return 'block-app-item';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            app: Object,
        };
    }
    constructor() {
        super();
        this.mojoInterfaceProvider = getAppParentalControlsProvider();
    }
    ready() {
        super.ready();
        this.addEventListener('click', () => {
            this.updateBlockedState_(!this.app.isBlocked);
        });
    }
    isAllowed_(app) {
        return !app.isBlocked;
    }
    onToggleChange_(e) {
        const isBlocked = !e.detail;
        this.updateBlockedState_(isBlocked);
    }
    updateBlockedState_(isBlocked) {
        this.mojoInterfaceProvider.updateApp(this.app.id, isBlocked);
    }
    getIconUrl_(app) {
        // Use a no-op query param that reflects the app blocked state.
        // This ensures that the icon is fetched every time the state of the app is
        // updated. Otherwise, the icon is cached if the src stays the same.
        return `chrome://app-icon/${app.id}/64?` +
            `parental_controls_blocked=${app.isBlocked}`;
    }
}
customElements.define(BlockAppItemElement.is, BlockAppItemElement);
