// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Used for metrics. Those values are logged to UMA. Entries should not be
// renumbered and numeric values should never be reused. Please keep in sync
// with "ChromeOS.OnDeviceControls.DialogAction" in
// src/tools/metrics/histograms/metadata/families/histograms.xml.
const AppParentalControlsDialogHistogramBaseName = 'ChromeOS.OnDeviceControls.DialogAction.';
// Used for metrics. Those values are logged to UMA. Entries should not be
// renumbered and numeric values should never be reused. Please keep in sync
// with "ChromeOS.OnDeviceControls.PinDialogError" in
// src/tools/metrics/histograms/metadata/families/histograms.xml.
const AppParentalControlsPinDialogErrorHistogram = 'ChromeOS.OnDeviceControls.PinDialogError';
export var ParentalControlsDialogType;
(function (ParentalControlsDialogType) {
    ParentalControlsDialogType["SET_UP_CONTROLS"] = "SetUpControls";
    ParentalControlsDialogType["ENTER_SUBPAGE_VERIFICATION"] = "VerifyToEnterControlsPage";
    ParentalControlsDialogType["DISABLE_CONTROLS_VERIFICATION"] = "VerifyToDisableControls";
})(ParentalControlsDialogType || (ParentalControlsDialogType = {}));
// Used for metrics. Those values are logged to UMA. Entries should not be
// renumbered and numeric values should never be reused. Please keep in sync
// with "OnDeviceControlsDialogAction" in
// src/tools/metrics/histograms/metadata/families/enums.xml.
export var ParentalControlsDialogAction;
(function (ParentalControlsDialogAction) {
    ParentalControlsDialogAction[ParentalControlsDialogAction["OPEN_DIALOG"] = 0] = "OPEN_DIALOG";
    ParentalControlsDialogAction[ParentalControlsDialogAction["FLOW_COMPLETED"] = 1] = "FLOW_COMPLETED";
})(ParentalControlsDialogAction || (ParentalControlsDialogAction = {}));
// Used for metrics. Those values are logged to UMA. Entries should not be
// renumbered and numeric values should never be reused. Please keep in sync
// with "OnDeviceControlsPinDialogError" in
// src/tools/metrics/histograms/metadata/families/enums.xml.
export var ParentalControlsPinDialogError;
(function (ParentalControlsPinDialogError) {
    ParentalControlsPinDialogError[ParentalControlsPinDialogError["INVALID_PIN_ON_SETUP"] = 0] = "INVALID_PIN_ON_SETUP";
    ParentalControlsPinDialogError[ParentalControlsPinDialogError["INCORRECT_PIN"] = 1] = "INCORRECT_PIN";
    ParentalControlsPinDialogError[ParentalControlsPinDialogError["FORGOT_PIN"] = 2] = "FORGOT_PIN";
})(ParentalControlsPinDialogError || (ParentalControlsPinDialogError = {}));
export function recordParentalControlsDialogOpened(dialogType) {
    chrome.metricsPrivate.recordEnumerationValue(getDialogHistogramName(dialogType), ParentalControlsDialogAction.OPEN_DIALOG, getEnumLength(ParentalControlsDialogAction));
}
export function recordParentalControlsDialogFlowCompleted(dialogType) {
    chrome.metricsPrivate.recordEnumerationValue(getDialogHistogramName(dialogType), ParentalControlsDialogAction.FLOW_COMPLETED, getEnumLength(ParentalControlsDialogAction));
}
export function recordPinDialogError(error) {
    chrome.metricsPrivate.recordEnumerationValue(AppParentalControlsPinDialogErrorHistogram, error, getEnumLength(ParentalControlsPinDialogError));
}
function getDialogHistogramName(dialogType) {
    return AppParentalControlsDialogHistogramBaseName.concat(dialogType);
}
function getEnumLength(histogramEnum) {
    return Object.keys(histogramEnum).filter((key) => isNaN(key)).length;
}
