import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#androidAppsRowIcon,#parentalControlsRowIcon{margin-inline-end:16px;--iron-icon-fill-color:var(--cros-sys-primary)}#androidApps[actionable]:hover,#appParentalControls[actionable]:hover{background-color:var(--cr-hover-background-color);cursor:pointer}</style>

<os-settings-animated-pages id="pages" section="[[section_]]">
  <div route-path="default">
    <settings-card header-text="$i18n{appsPageTitle}">
      <cr-link-row id="appManagementRow" class="settings-box first"
          start-icon="os-settings:apps"
          label="$i18n{appManagementTitle}"
          on-click="onClickAppManagement_"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <cr-link-row id="appNotificationsRow" class="settings-box"
          start-icon="os-settings:apps-notifications"
          label="$i18n{appNotificationsTitle}"
          on-click="onClickAppNotifications_"
          role-description="$i18n{subpageArrowRoleDescription}"
          sub-label="$i18n{appNotificationsRowSublabel}">
      </cr-link-row>
      <template is="dom-if" if="[[isAppParentalControlsFeatureAvailable_]]">
        <div id="appParentalControls"
            class="settings-box"
            actionable$="[[isParentalControlsSetupCompleted_]]"
            on-click="onClickParentalControls_">
          <iron-icon id="parentalControlsRowIcon"
              icon="os-settings:apps-parental-controls">
          </iron-icon>
          <div class="start settings-box-text">
            $i18n{appParentalControlsTitle}
            <div class="secondary">
              <localized-link
                  localized-string=
                      "[[i18nAdvanced('appParentalControlsSubtitle')]]">
              </localized-link>
            </div>
          </div>
          <template is="dom-if"
              if="[[!isParentalControlsSetupCompleted_]]"
              restamp>
            <div class="separator"></div>
            <cr-button
                on-click="setUpParentalControls_"
                aria-label="$i18n{appParentalControlsTitle}"
                aria-roledescription="$i18n{appParentalControlsSetUpButton}"
                deep-link-focus-id$="[[Setting.kAppParentalControls]]">
              $i18n{appParentalControlsSetUpButton}
            </cr-button>
          </template>
          <template is="dom-if"
              if="[[isParentalControlsSetupCompleted_]]"
              restamp>
            <cr-icon-button class="subpage-arrow"
                aria-label="$i18n{appParentalControlsTitle}"
                aria-description="$i18n{appParentalControlsSubtitleDescription}"
                aria-roledescription="$i18n{subpageArrowRoleDescription}"
                deep-link-focus-id$="[[Setting.kAppParentalControls]]">
            </cr-icon-button>
            <div class="separator"></div>
            <cr-toggle id="toggle"
                aria-label="$i18n{appParentalControlsTitle}"
                checked="[[isParentalControlsSetupCompleted_]]"
                on-change="disableParentalControls_">
            </cr-toggle>
          </template>
        </div>
        <template is="dom-if" if="[[showParentalControlsSetupPinDialog_]]"
            restamp>
          <app-setup-pin-dialog id="setupPin"
              on-close="onSetupPinDialogClose_"
              on-success="onSetupPinSuccess_"
              prefs="{{prefs}}">
          </app-setup-pin-dialog>
        </template>
        <template is="dom-if" if="[[showParentalControlsVerifyPinDialog_]]"
            restamp>
          <app-verify-pin-dialog id="verifyPin"
              on-close="onVerifyPinDialogClose_"
              on-pin-verified="onAccessPinVerified_"
              prefs="{{prefs}}">
          </app-verify-pin-dialog>
        </template>
        <template is="dom-if" if="[[showParentalControlsDisablePinDialog_]]"
            restamp>
          <app-verify-pin-dialog id="disableDialog"
              on-close="onDisablePinDialogClose_"
              on-pin-verified="onDisablePinVerified_"
              prefs="{{prefs}}">
          </app-verify-pin-dialog>
        </template>
      </template>
      <template is="dom-if" if="[[showAndroidApps_]]">
        <template is="dom-if" if="[[isPlayStoreAvailable_]]" restamp>
          <div id="androidApps" class="settings-box"
              actionable$="[[androidAppsInfo.playStoreEnabled]]"
              on-click="onAndroidAppsSubpageClick_">
            <iron-icon id="androidAppsRowIcon"
                icon="os-settings:google-play">
            </iron-icon>
            <div class="start settings-box-text">
              $i18n{androidAppsPageLabel}
              <div class="secondary" id="secondaryText">
                <localized-link
                    localized-string="[[i18nAdvanced('androidAppsSubtext')]]">
                </localized-link>
              </div>
            </div>
            <cr-policy-pref-indicator pref="[[prefs.arc.enabled]]"
                icon-aria-label="$i18n{androidAppsPageTitle}">
            </cr-policy-pref-indicator>
            <template is="dom-if" if="[[androidAppsInfo.playStoreEnabled]]">
              <cr-icon-button class="subpage-arrow"
                  aria-label="$i18n{androidAppsPageTitle}"
                  aria-description="$i18n{androidAppsSubtextDescription}"
                  aria-roledescription="$i18n{subpageArrowRoleDescription}">
              </cr-icon-button>
            </template>
            <template is="dom-if" if="[[!androidAppsInfo.playStoreEnabled]]">
              <div class="separator"></div>
              <cr-button id="arcEnable"
                  disabled="[[isEnforced_(prefs.arc.enabled)]]"
                  on-click="onEnableAndroidAppsClick_"
                  aria-label="$i18n{androidAppsPageTitle}"
                  aria-roledescription="$i18n{androidAppsEnableButtonRole}"
                  deep-link-focus-id$="[[Setting.kTurnOnPlayStore]]">
                $i18n{androidAppsEnable}
              </cr-button>
            </template>
          </div>
        </template>
        <template is="dom-if" if="[[!isPlayStoreAvailable_]]" restamp>
          <cr-link-row id="manageApps" class="settings-box"
              start-icon="os-settings:apps-android-settings"
              label="$i18n{androidAppsManageApps}"
              on-click="onManageAndroidAppsClick_"
              external
              deep-link-focus-id$="[[Setting.kManageAndroidPreferences]]">
          </cr-link-row>
        </template>
      </template>
      <template is="dom-if" if="[[showManageIsolatedWebAppsRow_]]">
        <cr-link-row id="manageIsoalatedWebAppsRow" class="settings-box"
            start-icon="os-settings:apps-manage-isolated-web-apps"
            label="$i18n{manageIsolatedWebAppsLinkText}"
            on-click="onClickManageIsolatedWebApps_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
      </template>
    </settings-card>
  </div>

  <!-- APP NOTIFICATIONS -->
  <template is="dom-if" route-path="/app-notifications">
    <os-settings-subpage page-title="$i18n{appNotificationsTitle}">
      <settings-app-notifications-subpage prefs="{{prefs}}">
      </settings-app-notifications-subpage>
    </os-settings-subpage>
  </template>

  <!-- APP NOTIFICATION MANAGEMENT -->
  <template is="dom-if" route-path="/app-notifications-manager">
    <os-settings-subpage
        page-title="$i18n{appNotificationsManagerLabel}"
        search-label="$i18n{appManagementSearchPrompt}"
        search-term="{{searchTerm}}">
      <settings-app-notifications-manager-subpage
          prefs="{{prefs}}" search-term="[[searchTerm]]">
      </settings-app-notifications-manager-subpage>
    </os-settings-subpage>
  </template>

  <!-- APP MANAGEMENT -->
  <template is="dom-if" route-path="/app-management">
    <os-settings-subpage
        page-title="$i18n{appManagementTitle}"
        search-label="$i18n{appManagementSearchPrompt}"
        search-term="{{searchTerm}}">
      <settings-app-management-page search-term="[[searchTerm]]">
      </settings-app-management-page>
    </os-settings-subpage>
  </template>

  <template is="dom-if" route-path="/app-management/detail">
    <os-settings-subpage
        page-title="[[app_.title]]"
        title-icon="[[iconUrlFromId_(app_)]]">
      <app-management-uninstall-button slot="subpage-title-extra"
          app="[[app_]]"
          uninstall-label="$i18n{appManagementUninstallLabel}"
          policy-label="$i18n{appManagementAppInstalledByPolicyLabel}">
      </app-management-uninstall-button>
      <app-management-app-detail-view prefs="{{prefs}}">
      </app-management-app-detail-view>
    </os-settings-subpage>
  </template>

  <!-- ANDROID APPS -->
  <template is="dom-if" if="[[showAndroidApps_]]" restamp>
    <template is="dom-if" route-path="/androidAppsDetails">
      <os-settings-subpage page-title="$i18n{androidAppsPageLabel}">
        <settings-android-apps-subpage
            prefs="{{prefs}}"
            android-apps-info="[[androidAppsInfo]]"
            is-arc-vm-manage-usb-available="[[isArcVmManageUsbAvailable_]]">
        </settings-android-apps-subpage>
      </os-settings-subpage>
    </template>
  </template>

  <template is="dom-if" if="[[isArcVmManageUsbAvailable_]]" restamp>
    <template is="dom-if" route-path="/androidAppsDetails/sharedUsbDevices">
      <os-settings-subpage page-title="$i18n{guestOsSharedUsbDevicesLabel}">
         <settings-guest-os-shared-usb-devices guest-os-type="arcvm"
            prefs="{{prefs}}">
         </settings-guest-os-shared-usb-devices>
      </os-settings-subpage>
    </template>
  </template>

  <!-- Plugin VM -->
  <template is="dom-if" if="[[isPluginVmAvailable_]]" restamp>
    <template is="dom-if" route-path="/app-management/pluginVm/sharedPaths">
      <os-settings-subpage page-title="$i18n{guestOsSharedPaths}">
        <settings-guest-os-shared-paths
            guest-os-type="pluginVm" prefs="{{prefs}}">
        </settings-guest-os-shared-paths>
      </os-settings-subpage>
    </template>
    <template is="dom-if"
        route-path="/app-management/pluginVm/sharedUsbDevices">
      <os-settings-subpage page-title="$i18n{guestOsSharedUsbDevicesLabel}">
        <settings-guest-os-shared-usb-devices guest-os-type="pluginVm"
            prefs="{{prefs}}">
        </settings-guest-os-shared-usb-devices>
      </os-settings-subpage>
    </template>
  </template>

  <!-- Manage Isolated Web Apps -->
  <template is="dom-if" if="[[showManageIsolatedWebAppsRow_]]">
    <template is="dom-if" route-path="/manage-isolated-web-apps">
      <os-settings-subpage page-title="$i18n{manageIsolatedWebAppsTitle}">
        <settings-manage-isolated-web-apps-subpage prefs="{{prefs}}">
        </settings-manage-isolated-web-apps-subpage>
      </os-settings-subpage>
    </template>
  </template>

  <!-- On-device Apps Parental Controls -->
  <template is="dom-if" if="[[isAppParentalControlsFeatureAvailable_]]">
    <template is="dom-if" route-path="/app-parental-controls">
      <os-settings-subpage page-title="$i18n{appParentalControlsTitle}"
       search-label="$i18n{appParentalControlsSearchPrompt}"
       search-term="{{searchTerm}}">
        <settings-app-parental-controls-subpage search-term="[[searchTerm]]"
            is-verified="[[isPinVerified_]]">
        </settings-app-parental-controls-subpage>
      </os-settings-subpage>
    </template>
  </template>

</os-settings-animated-pages>
<!--_html_template_end_-->`;
}
