import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-dialog-width:320px}[slot='button-container']{display:flex;justify-content:flex-end;margin:40px 0 20px 0;padding-top:0}:host([is-input-invalid_]) #inputInfo{color:var(--cros-text-color-alert)}#inputContainer{margin-top:24px}#changeNameInput{position:relative;z-index:1}#inputInfo{background-color:var(--cros-bg-color-elevation-3);color:var(--cros-text-color-secondary);display:flex;font-size:var(--cr-form-field-label-font-size);font-weight:400;height:30px;line-height:var(--cr-form-field-label-line-height);margin-top:-25px;padding-top:8px;position:relative;width:280px;z-index:2}:host-context([chrome-refresh-2023]) #inputInfo{margin-top:-15px}#inputSubtitle{width:260px}</style>

<cr-dialog id="dialog" show-on-attach>
  <div id="title" slot="title">
    $i18n{bluetoothDeviceDetailName}
  </div>
  <div slot="body">
    <div id="inputContainer">
      <!-- Set error-message so then it is read out by ChromeVox
          when cr-input is invalid. Since we already display the error
          message in #inputInfo, this is visually hidden by #inputInfo. -->
      <cr-input id="changeNameInput"
          value="{{deviceName_}}"
          spellcheck="false"
          aria-label="[[i18n('bluetoothDeviceDetailName')]]"
          invalid="[[isInputInvalid_]]"
          label="$i18n{bluetoothDeviceDetailChangeNameDialogNewName}"
          aria-description="[[i18n('bluetoothChangeNameDialogInputA11yLabel',
              maxInputLength)]]"
          error-message="[[i18n('bluetoothChangeNameDialogInputA11yLabel',
              maxInputLength)]]">
      </cr-input>
      <div id="inputInfo" aria-hidden="true">
        <span id="inputSubtitle">
          $i18n{bluetoothChangeNameDialogInputSubtitle}
        </span>
        <span id="inputCount">
          [[getInputCountString_(deviceName_)]]
        </span>
      </div>
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button"
        on-click="onCancelClick_">
      $i18n{bluetoothDeviceDetailChangeNameDialogCancel}
    </cr-button>
    <cr-button id="done"
        disabled$="[[isDoneDisabled_(device.*, deviceName_)]]"
        class="action-button"
        on-click="onDoneClick_">
      $i18n{bluetoothDeviceDetailChangeNameDialogDone}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
