import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host([is-device-connected_]) #bluetoothState{color:var(--cros-text-color-positive)}#connectionFailed{color:var(--cros-text-color-alert)}#managedIcon{flex:8}#forgetBtn{margin-inline-end:8px}.bluetooth-middle{align-items:center;flex:auto}.cancel-button{margin-inline-end:0}</style>
<div id="container">
  <div id="deviceStateSettings" class="settings-box two-line first">
    <bluetooth-icon device="[[device_.deviceProperties]]"></bluetooth-icon>
    <div id="bluetoothState"
        class="middle settings-box-text">
      <div
          id="bluetoothStateText"
          aria-live="polite"
          aria-label$="[[getDeviceStatusA11yLabel_(device_.*, pageState_)]]">
        [[getBluetoothStateTextLabel_(pageState_)]]
      </div>
      <template is="dom-if"
          if="[[shouldShowBatteryInfo_(device_.*, pageState_)]]"
          restamp>
        <bluetooth-device-battery-info
            aria-label$="[[getBatteryInfoA11yLabel_(device_.*)]]"
            id="batteryInfo"
            class="secondary"
            device="[[device_.deviceProperties]]"
            aria-live="polite">
        </bluetooth-device-battery-info>
      </template>
      <template is="dom-if" if="[[shouldShowErrorMessage_(device_.*, pageState_)]]"
          restamp>
        <div id="connectionFailed">
          [[i18n('bluetoothDeviceDetailConnectionFailureLabel')]]
        </div>
      </template>
    </div>
    <template is="dom-if"
        if="[[shouldShowBlockedByPolicyIcon_(device_.*)]]" restamp>
      <div id="managedIcon">
        <cr-tooltip-icon
            tooltip-text="$i18n{bluetoothManaged}" icon-class="cr:domain"
            icon-aria-label="$i18n{bluetoothManaged}">
        </cr-tooltip-icon>
      </div>
    </template>
    <div id="buttonContainer" class="layout end">
      <template is="dom-if" if="[[shouldShowForgetBtn_(device_.*)]]"
          restamp>
        <cr-button id="forgetBtn"
            class="cancel-button"
            aria-label$="[[getForgetA11yLabel_(device_.*)]]"
            on-click="onForgetButtonClicked_">
          $i18n{bluetoothDeviceDetailForget}
        </cr-button>
      </template>
      <template is="dom-if" if="[[shouldShowConnectDisconnectBtn_(device_.*)]]"
          restamp>
        <cr-button id="connectDisconnectBtn"
            disabled$="[[isConnectDisconnectBtnDisabled(pageState_)]]"
            class="action-button"
            on-click="onConnectDisconnectBtnClick_">
          [[getBluetoothConnectDisconnectBtnLabel_(isDeviceConnected_, pageState_)]]
        </cr-button>
      </template>
    </div>
  </div>
  <template is="dom-if"
      if="[[shouldShowTrueWirelessImages_(device_.*)]]" restamp>
    <os-settings-bluetooth-true-wireless-images
        id="trueWirelessImages"
        device="[[device_.deviceProperties]]">
    </os-settings-bluetooth-true-wireless-images>
  </template>
  <template is="dom-if"
      if="[[shouldShowNonAudioOutputDeviceMessage_(device_.*)]]" restamp>
    <div id="nonAudioOutputDeviceMessage"
        class="settings-box settings-box-text continuation"
        aria-live="polite">
      [[getNonAudioOutputDeviceMessage_(device_.*)]]
    </div>
  </template>
  <div id="deviceNameSettings" class="settings-box">
    <div id="bluetoothDeviceName"
        class="bluetooth-middle settings-box-text no-padding"
        aria-hidden="true">
      $i18n{bluetoothDeviceDetailName}
      <div class="secondary" id="bluetoothDeviceNameLabel">
        [[getDeviceNameUnsafe_(device_.*)]]
      </div>
    </div>
    <cr-button id="changeNameBtn"
        on-click="onChangeNameClick_"
        aria-label$="[[getChangeDeviceNameBtnA11yLabel_(device_.*)]]"
        class="layout end cancel-button">
      $i18n{bluetoothDeviceDetailChangeDeviceName}
    </cr-button>
  </div>
  <template is="dom-if"
      if="[[shouldShowChangeMouseDeviceSettings_(device_.*,
          isDeviceConnected_)]]" restamp>
    <cr-link-row
        id="changeMouseSettings"
        class="hr settings-box"
        on-click="onMouseRowClick_"
        label="$i18n{bluetoothDeviceDetailChangeDeviceSettingsMouse}">
    </cr-link-row>
  </template>
  <template is="dom-if"
      if="[[shouldShowChangeKeyboardDeviceSettings_(device_.*,
          isDeviceConnected_)]]" restamp>
    <cr-link-row
        id="changeKeyboardSettings"
        class="hr settings-box"
        on-click="onKeyboardRowClick_"
        label="$i18n{bluetoothDeviceDetailChangeDeviceSettingsKeyboard}">
    </cr-link-row>
  </template>
</div>

<template is="dom-if" if="[[shouldShowChangeDeviceNameDialog_]]" restamp>
  <os-settings-bluetooth-change-device-name-dialog
      id="changeDeviceNameDialog"
      device="[[device_]]"
      on-close="onCloseChangeDeviceNameDialog_">
  </os-settings-bluetooth-change-device-name-dialog>
</template>

<template is="dom-if" if="[[shouldShowForgetDeviceDialog_]]" restamp>
  <os-settings-bluetooth-forget-device-dialog
      id="forgetDeviceDialog"
      device_="[[device_]]"
      on-close="onCloseForgetDeviceDialog_">
  </os-settings-bluetooth-forget-device-dialog>
</template>
<!--_html_template_end_-->`;
}
