import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#container{padding-inline-end:calc(var(--cr-section-padding) - var(--cr-icon-ripple-padding));padding-inline-start:var(--cr-section-padding)}.device-lists-separator{border-top:var(--cr-separator-line);padding:0}.device-list{margin-inline-start:32px}</style>
<div class="settings-box first">
  <div class="primary-toggle start" on$="[[isBluetoothToggleOn_]]"
      aria-hidden="true">
    [[getOnOffString_(isBluetoothToggleOn_,
        '$i18nPolymer{deviceOn}', '$i18nPolymer{deviceOff}')]]
  </div>
  <cr-toggle id="enableBluetoothToggle"
      checked="{{isBluetoothToggleOn_}}"
      on-change="onBluetoothToggleChange_"
      disabled="[[isToggleDisabled_(systemProperties.systemState)]]"
      aria-label="$i18n{bluetoothToggleA11yLabel}"
      deep-link-focus-id$="[[Setting.kBluetoothOnOff]]">
  </cr-toggle>
</div>
<div class="device-lists-separator"></div>
<div id="container">
  <template is="dom-if"
      if="[[shouldShowNoDevicesFound_(unconnectedDevices_.length,
          connectedDevices_.length)]]" restamp>
    <div id="noDevices" class="settings-box-text">
      $i18n{bluetoothDeviceListNoConnectedDevices}
    </div>
  </template>
  <template is="dom-if"
      if="[[shouldShowDeviceList_(connectedDevices_,
          connectedDevices_.length)]]" restamp>
    <h2 class="settings-box-text">
      $i18n{bluetoothDeviceListCurrentlyConnected}
    </h2>
    <div class="device-list">
      <os-settings-paired-bluetooth-list
          id="connectedDeviceList"
          devices="[[connectedDevices_]]">
      </os-settings-paired-bluetooth-list>
    </div>
  </template>
  <template is="dom-if"
      if="[[shouldShowDeviceList_(unconnectedDevices_,
          unconnectedDevices_.length)]]" restamp>
    <h2 class="settings-box-text">
      $i18n{bluetoothDeviceListPreviouslyConnected}
    </h2>
    <div class="device-list">
      <os-settings-paired-bluetooth-list
          id="unconnectedDeviceList"
          devices="[[unconnectedDevices_]]">
      </os-settings-paired-bluetooth-list>
    </div>
  </template>
</div>
<template is="dom-if"
    if="[[isFastPairSavedDevicesRowVisible_(isFastPairSupportedByDevice_)]]">
  <cr-link-row
      class="hr two-line"
      id="savedDevicesRowLink"
      label="$i18n{savedDevicesLabel}"
      sub-label="[[savedDevicesSublabel_]]"
      on-click="onClicked_">
  </cr-link-row>
</template>

<template is="dom-if"
    if="[[isFastPairToggleVisible_(isFastPairSupportedByDevice_)]]">
  <div class="device-lists-separator"></div>
  <settings-fast-pair-toggle prefs="{{prefs}}"
    id="enableFastPairToggle"
    deep-link-focus-id$="[[Setting.kFastPairOnOff]]"
    bluetooth-toggle-on-off="[[isBluetoothToggleOn_]]">
  </settings-fast-pair-toggle>
</template>
<!--_html_template_end_-->`;
}
