import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex"></style>
<os-settings-animated-pages id="pages"
    section="[[section_]]">
  <div route-path="default">
    <settings-card header-text="$i18n{bluetoothPageTitle}">
      <os-settings-bluetooth-summary
          on-start-pairing="onStartPairing_"
          system-properties="[[systemProperties_]]">
      </os-settings-bluetooth-summary>
    </settings-card>
  </div>

  <template is="dom-if" route-path="/bluetoothDevices">
    <!-- TODO(b/332926512): remove hide-back-button once Bluetooth L1 page is reactivated -->
    <os-settings-subpage page-title="$i18n{bluetoothPageTitle}"
        hide-back-button>
      <div slot="subpage-title-extra">
        <template is="dom-if"
            if="[[shouldShowPairNewDevice_(systemProperties_.*)]]" restamp>
          <cr-button id="pairNewDevice"
              on-click="onStartPairing_"
              class="cancel-button">
            <iron-icon icon="cr:add" slot="prefix-icon">
            </iron-icon>
            $i18n{bluetoothPairNewDevice}
          </cr-button>
        </template>
      </div>
      <os-settings-bluetooth-devices-subpage
          prefs="{{prefs}}"
          system-properties="[[systemProperties_]]">
      </os-settings-bluetooth-devices-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/bluetoothDeviceDetail">
    <os-settings-subpage>
      <os-settings-bluetooth-device-detail-subpage
          system-properties="[[systemProperties_]]">
      </os-settings-bluetooth-device-detail-subpage>
    </os-settings-subpage>
  </template>
  <os-settings-subpage route-path="/bluetoothSavedDevices"
      show-spinner="[[showSavedDevicesLoadingIndicators_]]">
    <os-settings-bluetooth-saved-devices-subpage
        show-saved-devices-loading-label=
        "{{showSavedDevicesLoadingIndicators_}}">
    </os-settings-bluetooth-saved-devices-subpage>
  </os-settings-subpage>
</os-settings-animated-pages>

<template is="dom-if" if="[[shouldShowPairingDialog_]]" restamp>
  <os-settings-bluetooth-pairing-dialog on-close="onClosePairingDialog_">
  </os-settings-bluetooth-pairing-dialog>
</template>
<!--_html_template_end_-->`;
}
