import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared os-settings-icons">#pairNewDeviceBtn{margin-inline-end:20px}#statusIcon{--iron-icon-fill-color:var(--cros-sys-primary)}</style>
<template is="dom-if" if="[[!isSecondaryUser_]]" >
  <div id="bluetoothSummary" class="settings-box two-line first no-padding">
    <div class="link-wrapper" actionable on-click="onWrapperClick_">
      <iron-icon id="statusIcon"
          icon="[[getBluetoothStatusIconName_(
            systemProperties.*, isBluetoothToggleOn_)]]">
      </iron-icon>
      <div id="bluetoothPageTitle"
          class="middle settings-box-text"
          aria-hidden="true">
        $i18n{bluetoothPageTitle}
        <div class="secondary" id="bluetoothSecondaryLabel">
          [[getSecondaryLabel_(LabelTypeEnum_.DISPLAYED_TEXT, systemProperties.*, isBluetoothToggleOn_)]]
        </div>
      </div>
      <template is="dom-if"
          if="[[shouldShowSubpageArrow_(
            systemProperties.*, isBluetoothToggleOn_)]]"
          restamp>
        <cr-icon-button id="arrowIconButton"
            class="subpage-arrow layout end"
            on-click="onSubpageArrowClick_"
            aria-label="$i18n{bluetoothPageTitle}"
            aria-description$="[[getSecondaryLabel_(
              LabelTypeEnum_.A11Y, systemProperties.*, isBluetoothToggleOn)]]"
            aria-roledescription="$i18n{subpageArrowRoleDescription}">
        </cr-icon-button>
      </template>
    </div>
    <div class="separator"></div>
    <cr-toggle id="enableBluetoothToggle"
        class="margin-matches-padding"
        checked="{{isBluetoothToggleOn_}}"
        on-change="onBluetoothToggleChange_"
        disabled$="[[isToggleDisabled_(systemProperties.systemState)]]"
        aria-label="$i18n{bluetoothToggleA11yLabel}">
    </cr-toggle>
  </div>

  <template is="dom-if" if="[[shouldShowPairNewDevice_(systemProperties.*)]]" restamp>
    <div id="pairNewDevice" class="settings-box no-padding" actionable
        on-click="onPairNewDeviceBtnClick_">
      <div id="pairNewDeviceLabel" class="middle settings-box-text"
          aria-hidden="true">
        $i18n{bluetoothPairNewDevice}
      </div>
      <cr-icon-button id="pairNewDeviceBtn"
          on-click="onPairNewDeviceBtnClick_"
          class="icon-pair-bluetooth layout end"
          aria-labelledby="pairNewDeviceLabel">
      </cr-icon-button>
    </div>
  </template>
</template>

<template is="dom-if" if="[[isSecondaryUser_]]">
  <div id="bluetoothSummarySeconday" class="settings-box two-line">
    <iron-icon class="policy" icon="cr:group"></iron-icon>
    <div id="bluetoothSummarySecondayText" class="middle settings-box-text">
      [[i18n('bluetoothPrimaryUserControlled', primaryUserEmail_)]]
    </div>
  </div>
</template>
<!--_html_template_end_-->`;
}
