import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">bluetooth-device-battery-info{padding-top:3px}</style>
<div focus-row-container>
  <div class="list-item"
      focus-row-control
      focus-type="rowWrapper"
      role="button"
      selectable
      aria-label="[[getAriaLabel_(device, itemIndex, listSize)]]"
      on-keydown="onKeydown_"
      on-click="onSelected_">
    <bluetooth-icon device="[[device.deviceProperties]]"></bluetooth-icon>
    <div class="middle" aria-hidden="true">
      <div id="deviceName">[[getDeviceNameUnsafe_(device)]]</div>
      <template is="dom-if"
          if="[[shouldShowBatteryInfo_(device)]]" restamp>
        <bluetooth-device-battery-info
            device="[[device.deviceProperties]]">
        </bluetooth-device-battery-info>
      </template>
      <div id="subtitle" class="secondary"
          hidden$="[[!isDeviceConnecting_(device)]]">
        $i18n{bluetoothConnecting}
      </div>
    </div>
    <template is="dom-if"
        if="[[device.deviceProperties.isBlockedByPolicy]]" restamp>
      <iron-icon id="managedIcon" icon="cr:domain"
          tabindex="0"
          on-mouseenter="onShowTooltip_"
          on-focus="onShowTooltip_"
          aria-label="$i18n{bluetoothManaged}"
          role="img">
      </iron-icon>
    </template>
    <div>
      <cr-icon-button id="subpageButton"
          tabindex="-1"
          class="subpage-arrow"
          on-click="onSelected_"
          aria-hidden="true">
      </cr-icon-button>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}
