import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#disconnectGoogleDriveAccountToggle{--cr-icon-button-margin-end:16px;--iron-icon-fill-color:var(--cros-sys-primary)}#smbSharesIcon{fill:var(--cros-sys-primary);margin-inline-end:16px}#smbSharesTextContainer{flex:1}</style>

<settings-card header-text="$i18n{filesPageTitle}">
  <cr-link-row id="googleDriveRow"
      start-icon="os-settings:google-drive"
      on-click="onClickGoogleDrive_"
      label="$i18n{googleDriveLabel}"
      role-description="$i18n{subpageArrowRoleDescription}">
      <div id="googleDriveSubLabel" slot="sub-label"
          inner-h-t-m-l="[[getGoogleDriveSubLabelInnerHtml_(driveDisabled_, bulkPinningPrefEnabled_, mirrorSyncPrefEnabled_)]]">
      </div>
  </cr-link-row>

  <template is="dom-if" if="[[shouldShowOneDriveSettings_]]">
    <cr-link-row id="oneDriveRow"
        start-icon="os-settings:onedrive"
        class="hr"
        on-click="onClickOneDrive_"
        label="$i18n{oneDriveLabel}"
        sub-label="[[computeOneDriveSignedInLabel_(oneDriveConnectionState_)]]"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
  </template>

  <template is="dom-if" if="[[shouldShowOfficeSettings_]]">
    <cr-link-row id="officeRow"
          class="hr"
          start-icon="os-settings:ms365"
          on-click="onClickOffice_"
          label="$i18n{officeLabel}"
          sub-label="$i18n{officeSublabel}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
  </template>

  <template is="dom-if" if="[[shouldShowAddSmbButton_]]" restamp>
    <div id="addSmbSharesRow" class="settings-box two-line">
      <iron-icon id="smbSharesIcon" icon="os-settings:folder-shared">
      </iron-icon>
      <div id="smbSharesTextContainer" class="start">
        <div class="settings-box-text">
          <div>
            $i18n{smbSharesTitle}
          </div>
          <div id="secondaryText" class="secondary">
            <localized-link
                localized-string="$i18n{smbSharesTitleDescription}"
                link-url="$i18n{smbSharesLearnMoreURL}">
            </localized-link>
          </div>
        </div>
      </div>
      <controlled-button id="addShareButton"
          on-click="openAddSmbDialog_"
          label="$i18n{addSmbShare}"
          disabled="[[!prefs.network_file_shares.allowed.value]]"
          pref="[[prefs.network_file_shares.allowed]]"
          end-justified>
      </controlled-button>
    </div>
  </template>

  <template is="dom-if" if="[[computeShowSmbLinkRow_(shouldShowAddSmbButton_)]]" restamp>
    <cr-link-row id="smbSharesRow"
        start-icon="os-settings:folder-shared"
        class="hr"
        on-click="onClickSmbShares_"
        label="$i18n{smbSharesTitle}"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
  </template>
</settings-card>

<template is="dom-if" if="[[shouldShowAddSmbDialog_]]" restamp>
  <add-smb-share-dialog on-close="closeAddSmbDialog_"
      last-url="[[prefs.network_file_shares.most_recently_used_url.value]]"
      should-open-file-manager-after-mount>
  </add-smb-share-dialog>
</template>
<!--_html_template_end_-->`;
}
