import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#driveAccountEmail{font:var(--cros-button-2-font)}.subsection-header{height:24px;padding-inline-start:var(--cr-section-padding);padding-top:12px}.subsection{margin-bottom:8px;padding-inline-start:var(--cr-section-indent-width)}</style>

<div class="settings-box two-line first">
  <div class="start"
      inner-h-t-m-l="[[getDriveAccountStatusLabel_(driveDisabled_)]]">
  </div>
  <controlled-button id="driveConnectDisconnect"
      on-click="onConnectDisconnectClick_"
      pref="{{prefs.gdata.disabled}}"
      label="[[getConnectDisconnectButtonLabel_(driveDisabled_)]]"
      deep-link-focus-id$="[[Setting.kGoogleDriveRemoveAccess]]">
  </controlled-button>
  <template is="dom-if"
      if="[[shouldShowConfirmationDialog_(dialogType_, 'disconnect')]]" restamp>
    <settings-drive-confirmation-dialog
        id="driveDisconnectDialog"
        cancel-button-text="$i18n{cancel}"
        action-button-text="$i18n{googleDriveRemoveButtonText}"
        title-text="$i18n{googleDriveRemoveAccessDialogTitle}"
        body-text="$i18n{googleDriveRemoveAccessDialogBody}"
        on-close="onDriveConfirmationDialogClose_">
    </settings-drive-confirmation-dialog>
  </template>
</div>

<div class="hr"></div>

<template is="dom-if" if="[[!driveDisabled_]]" restamp>
  <template is="dom-if"
      if="[[and_(bulkPinningVisible_, isDriveFsBulkPinningEnabled_)]]"
      restamp>
    <settings-toggle-button
        id="driveBulkPinning"
        pref="{{prefs.drivefs.bulk_pinning_enabled}}"
        label="$i18n{googleDriveFileSyncTitle}"
        sub-label="[[getBulkPinningSubLabel_(bulkPinningStatus_)]]"
        learn-more-url="$i18n{googleDriveFileSyncLearnMoreLink}"
        on-settings-boolean-control-change="onToggleBulkPinning_"
        no-set-pref
        deep-link-focus-id$="[[Setting.kGoogleDriveFileSync]]">
    </settings-toggle-button>

    <template is="dom-if"
        if="[[shouldShowConfirmationDialog_(dialogType_, 'bulk-pinning-disable')]]"
        restamp>
      <settings-drive-confirmation-dialog
          id="driveBulkPinningDisableDialog"
          cancel-button-text="$i18n{cancel}"
          action-button-text="$i18n{googleDriveTurnOffLabel}"
          title-text="$i18n{googleDriveFileSyncTurnOffTitle}"
          body-text="$i18n{googleDriveFileSyncTurnOffBody}"
          on-close="onDriveConfirmationDialogClose_">
      </settings-drive-confirmation-dialog>
    </template>

    <template is="dom-if"
        if="[[shouldShowConfirmationDialog_(dialogType_, 'bulk-pinning-listing-files')]]"
        restamp>
      <settings-drive-confirmation-dialog
          id="driveBulkPinningListingFilesDialog"
          cancel-button-text="$i18n{googleDriveOkButtonText}"
          title-text="$i18n{googleDriveFileSyncListingFilesTitle}"
          body-text="[[getListingFilesDialogBody_(listedFiles_)]]"
          on-close="onDriveConfirmationDialogClose_">
      </settings-drive-confirmation-dialog>
    </template>

    <template is="dom-if"
        if="[[shouldShowConfirmationDialog_(dialogType_, 'bulk-pinning-not-enough-space')]]"
        restamp>
      <settings-drive-confirmation-dialog
          id="driveBulkPinningNotEnoughSpaceDialog"
          cancel-button-text="$i18n{googleDriveOkButtonText}"
          title-text="$i18n{googleDriveNotEnoughSpaceTitle}"
          body-text="$i18n{googleDriveNotEnoughSpaceBody}"
          on-close="onDriveConfirmationDialogClose_">
      </settings-drive-confirmation-dialog>
    </template>

    <template is="dom-if"
        if="[[shouldShowConfirmationDialog_(dialogType_, 'bulk-pinning-unexpected-error')]]"
        restamp>
      <settings-drive-confirmation-dialog
          id="driveBulkPinningUnexpectedErrorDialog"
          cancel-button-text="$i18n{googleDriveDismissButtonText}"
          title-text="$i18n{googleDriveFileSyncUnexpectedErrorTitle}"
          body-text="$i18n{googleDriveFileSyncUnexpectedErrorBody}"
          on-close="onDriveConfirmationDialogClose_">
      </settings-drive-confirmation-dialog>
    </template>

    <template is="dom-if"
        if="[[shouldShowConfirmationDialog_(dialogType_, 'bulk-pinning-offline')]]"
        restamp>
      <settings-drive-confirmation-dialog
          id="driveBulkPinningOfflineDialog"
          cancel-button-text="$i18n{googleDriveOkButtonText}"
          title-text="$i18n{googleDriveFileSyncOfflineErrorTitle}"
          body-text="$i18n{googleDriveFileSyncOfflineErrorBody}"
          on-close="onDriveConfirmationDialogClose_">
      </settings-drive-confirmation-dialog>
    </template>
  </template>

  <div class="settings-box two-line" id="drive-offline-storage-row">
    <div class="start">
      $i18n{googleDriveOfflineStorageTitle}
      <div class="secondary">
        [[getContentCacheSizeLabel_(contentCacheSize_)]]
      </div>
    </div>
    <div id="cleanUpStorageButtonWrapper">
      <cr-button role="button"
          on-click="onCleanUpStorage_"
          disabled="[[!shouldEnableCleanUpStorageButton_(bulkPinningStatus_, contentCacheSize_)]]"
          on-focus="onShowTooltip_"
          on-mouseenter="onShowTooltip_">
        $i18n{googleDriveCleanUpStorageAction}
      </cr-button>
    </div>
    <template is="dom-if"
        if="[[!shouldEnableCleanUpStorageButton_(bulkPinningStatus_, contentCacheSize_)]]"
        restamp>
      <paper-tooltip id="cleanUpStorageTooltip"
          for="cleanUpStorageButtonWrapper"
          fit-to-visible-bounds part="tooltip">
        [[getCleanUpStorageDisabledTooltipText_(contentCacheSize_)]]
      </paper-tooltip>
    </template>
  </div>

  <template is="dom-if"
      if="[[shouldShowConfirmationDialog_(dialogType_, 'bulk-pinning-clean-up-storage')]]"
      restamp>
    <settings-drive-confirmation-dialog
        id="driveBulkPinningCleanUpStorageConfirmationDialog"
        cancel-button-text="$i18n{cancel}"
        action-button-text="$i18n{googleDriveCleanUpStorageAction}"
        title-text="$i18n{googleDriveOfflineCleanStorageDialogTitle}"
        on-close="onDriveConfirmationDialogClose_">
      <localized-link
          localized-string="[[getCleanUpStorageConfirmationDialogBody()]]"
          localized-link="$i18n{googleDriveCleanUpStorageLearnMoreLink}">
      </localized-link>
    </settings-drive-confirmation-dialog>
  </template>

  <div class="hr"></div>

  <settings-toggle-button
      id="driveEnableDriveOnMeteredNetworkToggle"
      inverted="true"
      pref="{{prefs.gdata.cellular.disabled}}"
      label="$i18n{googleDriveEnabledOnMeteredNetworkLabel}">
  </settings-toggle-button>

  <template is="dom-if"
      if="[[isDriveFsMirrorSyncEnabled_]]"
      restamp>
    <div class="hr"></div>
    <h2 class="subsection-header">$i18n{googleDriveFileSyncSectionTitle}</h2>
    <!-- TODO(b/338154540): Move Bulk pinning into File Sync section. -->
    <div class="subsection">
      <settings-toggle-button
          id="driveFsMirrorSync"
          pref="{{prefs.drivefs.enable_mirror_sync}}"
          label="$i18n{googleDriveMirrorSyncLabel}"
          sub-label="[[getMirrorSyncDescription_()]]">
      </settings-toggle-button>
    </div>
  </template>
</template>
<!--_html_template_end_-->`;
}
