import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!-- TODO(crbug.com/1201535): Move this component out of the os_languages_page
     directory. -->
<style include="settings-shared shared-style">[slot=body]{display:flex;flex-direction:column;height:350px;overflow:auto}iron-icon[icon='cr20:domain']{margin-inline-end:10px}cr-search-field{margin-top:20px}cr-search-field::part(searchInput){font:var(--cros-body-2-font)}.managed-by-policy{font:var(--cros-body-2-font);padding-left:0px}.label{padding-bottom:4px;padding-top:8px}.list-item{color:var(--cros-text-color-primary);min-height:36px}cr-checkbox::part(label-container){white-space:nowrap}</style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">
    <div id="heading">[[header]]</div>
    <cr-search-field label="[[searchLabel]]" id="search"
        clear-label="$i18n{clearSearch}" autofocus
        on-search-changed="onSearchChanged_" on-keydown="onKeydown_">
    </cr-search-field>
    <template is="dom-if" if="[[showManagedByPolicy]]">
      <div class="managed-by-policy cr-row continuation" id="managedByPolicy">
        <iron-icon icon="cr20:domain"></iron-icon>
        <div class="secondary">[[managedByPolicyLabel]]</div>
      </div>
    </template>
  </div>
  <div id="dialog-body" slot="body" scrollable>
    <template is="dom-if" if="[[showSuggestedList_]]">
      <div id="suggested-items-label" class="label">
        [[suggestedItemsLabel]]
      </div>
      <iron-list id="suggested-items-list" items="[[suggestedItems_]]"
          scroll-target="dialog-body">
        <template>
          <cr-checkbox class="list-item no-outline"
              checked="[[willAdd_(item.id, itemIdsToAdd_.size)]]"
              tab-index="[[tabIndex]]" on-change="onCheckboxChange_">
              [[item.name]]
          </cr-checkbox>
        </template>
      </iron-list>
    </template>
    <template is="dom-if" if="[[showFilteredList_]">
      <div id="filtered-items-label" class="label"
          hidden="[[!showSuggestedList_]]">
        [[allItemsLabel]]
      </div>
      <iron-list id="filtered-items-list" items="[[filteredItems_]]"
          scroll-target="dialog-body">
        <template>
          <cr-checkbox
              class="list-item no-outline"
              checked="[[willAdd_(item.id, itemIdsToAdd_.size)]]"
              disabled="[[item.disabledByPolicy]]"
              tab-index="[[tabIndex]]" on-change="onCheckboxChange_">
            [[item.name]]
          </cr-checkbox>
        </template>
      </iron-list>
    </template>
    <div id="no-search-results" class="centered-message"
        hidden="[[showFilteredList_]]">
      $i18n{noSearchResults}
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelButtonClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" disabled="[[disableActionButton_]]"
        on-click="onActionButtonClick_">
      $i18n{add}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
