import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.app-icon{height:32px;width:32px;margin-inline-end:20px}.app-info{flex:1;overflow:hidden;text-overflow:ellipsis}cr-action-menu .dropdown-item{min-height:36px}</style>

<div class="cr-row continuation" id="appLanguagesDescription">
  [[getAppLanguagesDescription(appList_)]]
</div>
<div>
  <iron-list items="[[appList_]]">
    <template>
      <div class="cr-row" id="appItem">
        <img class="app-icon" src="[[iconUrlFromApp_(item)]]"
            aria-hidden="true">
        <div class="app-info cr-padded-text" aria-hidden="true">
          [[item.title]]
          <div class="secondary" aria-hidden="true">
            [[getSelectedLocale_(item)]]
          </div>
        </div>
        <cr-icon-button
            class="icon-more-vert"
            title="$i18n{moreActions}"
            on-click="onDotsClick_"
            aria-label="[[getChangeLanguageButtonDescription_(item)]]">
        </cr-icon-button>
      </div>
    </template>
  </iron-list>
</div>

<cr-lazy-render id="menu">
  <template>
    <cr-action-menu
        role-description="$i18n{menu}">
      <button
          id="editLanguage"
          class="dropdown-item"
          role="menuitem"
          on-click="onEditLanguageClick">
        $i18n{appLanguagesEditSelectionLabel}
      </button>
      <button
          id="resetLanguage"
          class="dropdown-item"
          role="menuitem"
          on-click="onResetLanguageClick">
        $i18n{appLanguagesResetSelectionLabel}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<template is="dom-if" if="[[showSelectLanguageDialog_]]" restamp>
  <app-language-selection-dialog
      app="[[selectedApp_]]"
      prefs="{{prefs}}"
      on-close="onSelectLanguageDialogClose_"
      entry-point="[[getDialogEntryPoint_()]]">
  </app-language-selection-dialog>
</template>
<!--_html_template_end_-->`;
}
