import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex shared-style">#dialogBody{display:flex;flex-direction:column;height:336px;overflow:auto;padding-inline-end:0;padding-inline-start:0}cr-search-field{margin-bottom:16px;margin-inline-end:var(--dialog-horizontal-padding);margin-inline-start:var(--dialog-horizontal-padding);margin-top:16px}iron-icon[icon='cr:check-circle']{--iron-icon-fill-color:var(--cr-link-color);margin-inline-end:26px}iron-list>div:not(.selected):hover{background-color:var(--cros-menu-item-bg-color-focus)}[scrollable] iron-list>:not(.no-outline):focus{background-color:var(--cros-menu-item-bg-color-focus)}[scrollable] iron-list>.selected:not(.no-outline):focus{background-color:transparent}.list-item{color:var(--cros-text-color-primary);min-height:36px}.padded{padding-inline-end:var(--dialog-horizontal-padding);padding-inline-start:var(--dialog-horizontal-padding)}paper-ripple{color:var(--cros-menu-item-ripple-color)}</style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">$i18n{changeDeviceLanguageDialogTitle}</div>
  <div id="dialogBody" slot="body" scrollable>
    <localized-link class="padded"
        localized-string="[[i18nAdvanced(
            'changeDeviceLanguageDialogDescription')]]">
    </localized-link>
    <cr-search-field label="$i18n{searchLanguages}"
        id="search" on-search-changed="onSearchChanged_"
        clear-label="$i18n{clearSearch}" on-keydown="onKeydown_" autofocus>
    </cr-search-field>
    <iron-list scroll-target="[[$$('[slot=body]')]]"
        items="[[displayedLanguages_]]" selection-enabled
        selected-item="{{selectedLanguage_}}"
        hidden$="[[displayedLanguagesEmpty_]]">
      <template>
        <!-- |selected| is a property of iron-list -->
        <div class$="list-item [[getItemClass_(selected)]]"
            tabindex$="[[tabIndex]]"
            aria-label="[[getAriaLabelForItem_(item, selected)]]">
          <paper-ripple></paper-ripple>
          <div class="flex padded" aria-hidden="true">
            [[getDisplayText_(item)]]
          </div>
          <iron-icon icon="cr:check-circle" hidden="[[!selected]]">
          </iron-icon>
        </div>
      </template>
    </iron-list>
    <div id="no-search-results" class="centered-message"
        hidden$="[[!displayedLanguagesEmpty_]]">
      $i18n{noSearchResults}
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelButtonClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onActionButtonClick_"
        disabled="[[disableActionButton_]]">
      $i18n{changeDeviceLanguageConfirmButtonLabel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
